// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_target_http_proxies/v1/region_target_http_proxies.proto

#include "google/cloud/compute/region_target_http_proxies/v1/region_target_http_proxies_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_target_http_proxies_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionTargetHttpProxiesClient::RegionTargetHttpProxiesClient(
    std::shared_ptr<RegionTargetHttpProxiesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionTargetHttpProxiesClient::~RegionTargetHttpProxiesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::DeleteTargetHttpProxy(
    std::string const& project, std::string const& region,
    std::string const& target_http_proxy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::
      DeleteTargetHttpProxyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_http_proxy(target_http_proxy);
  return connection_->DeleteTargetHttpProxy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionTargetHttpProxiesClient::DeleteTargetHttpProxy(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& target_http_proxy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::
      DeleteTargetHttpProxyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_http_proxy(target_http_proxy);
  return connection_->DeleteTargetHttpProxy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::DeleteTargetHttpProxy(
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        DeleteTargetHttpProxyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetHttpProxy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionTargetHttpProxiesClient::DeleteTargetHttpProxy(
    NoAwaitTag,
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        DeleteTargetHttpProxyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetHttpProxy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::DeleteTargetHttpProxy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTargetHttpProxy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::TargetHttpProxy>
RegionTargetHttpProxiesClient::GetTargetHttpProxy(
    std::string const& project, std::string const& region,
    std::string const& target_http_proxy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::
      GetTargetHttpProxyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_http_proxy(target_http_proxy);
  return connection_->GetTargetHttpProxy(request);
}

StatusOr<google::cloud::cpp::compute::v1::TargetHttpProxy>
RegionTargetHttpProxiesClient::GetTargetHttpProxy(
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        GetTargetHttpProxyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTargetHttpProxy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::InsertTargetHttpProxy(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::TargetHttpProxy const&
        target_http_proxy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::
      InsertTargetHttpProxyRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_target_http_proxy_resource() = target_http_proxy_resource;
  return connection_->InsertTargetHttpProxy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionTargetHttpProxiesClient::InsertTargetHttpProxy(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::TargetHttpProxy const&
        target_http_proxy_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::
      InsertTargetHttpProxyRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_target_http_proxy_resource() = target_http_proxy_resource;
  return connection_->InsertTargetHttpProxy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::InsertTargetHttpProxy(
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        InsertTargetHttpProxyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertTargetHttpProxy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionTargetHttpProxiesClient::InsertTargetHttpProxy(
    NoAwaitTag,
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        InsertTargetHttpProxyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertTargetHttpProxy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::InsertTargetHttpProxy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertTargetHttpProxy(operation);
}

StreamRange<google::cloud::cpp::compute::v1::TargetHttpProxy>
RegionTargetHttpProxiesClient::ListRegionTargetHttpProxies(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::
      ListRegionTargetHttpProxiesRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionTargetHttpProxies(request);
}

StreamRange<google::cloud::cpp::compute::v1::TargetHttpProxy>
RegionTargetHttpProxiesClient::ListRegionTargetHttpProxies(
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        ListRegionTargetHttpProxiesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionTargetHttpProxies(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::SetUrlMap(
    std::string const& project, std::string const& region,
    std::string const& target_http_proxy,
    google::cloud::cpp::compute::v1::UrlMapReference const&
        url_map_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::SetUrlMapRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_http_proxy(target_http_proxy);
  *request.mutable_url_map_reference_resource() = url_map_reference_resource;
  return connection_->SetUrlMap(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionTargetHttpProxiesClient::SetUrlMap(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& target_http_proxy,
    google::cloud::cpp::compute::v1::UrlMapReference const&
        url_map_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_target_http_proxies::v1::SetUrlMapRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_target_http_proxy(target_http_proxy);
  *request.mutable_url_map_reference_resource() = url_map_reference_resource;
  return connection_->SetUrlMap(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::SetUrlMap(
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        SetUrlMapRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetUrlMap(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionTargetHttpProxiesClient::SetUrlMap(
    NoAwaitTag,
    google::cloud::cpp::compute::region_target_http_proxies::v1::
        SetUrlMapRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetUrlMap(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionTargetHttpProxiesClient::SetUrlMap(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetUrlMap(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_target_http_proxies_v1
}  // namespace cloud
}  // namespace google
