// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_CLOUD_CONTROLS_PARTNER_CORE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_CLOUD_CONTROLS_PARTNER_CORE_CLIENT_H

#include "google/cloud/cloudcontrolspartner/v1/cloud_controls_partner_core_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class CloudControlsPartnerCoreClient {
 public:
  explicit CloudControlsPartnerCoreClient(
      std::shared_ptr<CloudControlsPartnerCoreConnection> connection,
      Options opts = {});
  ~CloudControlsPartnerCoreClient();

  ///@{
  /// @name Copy and move support
  CloudControlsPartnerCoreClient(CloudControlsPartnerCoreClient const&) =
      default;
  CloudControlsPartnerCoreClient& operator=(
      CloudControlsPartnerCoreClient const&) = default;
  CloudControlsPartnerCoreClient(CloudControlsPartnerCoreClient&&) = default;
  CloudControlsPartnerCoreClient& operator=(CloudControlsPartnerCoreClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(CloudControlsPartnerCoreClient const& a,
                         CloudControlsPartnerCoreClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(CloudControlsPartnerCoreClient const& a,
                         CloudControlsPartnerCoreClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Gets details of a single workload
  ///
  /// @param name  Required. Format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetWorkloadRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L139}
  /// [google.cloud.cloudcontrolspartner.v1.Workload]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Workload> GetWorkload(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single workload
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.GetWorkloadRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Workload])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetWorkloadRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L139}
  /// [google.cloud.cloudcontrolspartner.v1.Workload]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Workload> GetWorkload(
      google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists customer workloads for a given customer org id
  ///
  /// @param parent  Required. Parent resource
  ///  Format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.Workload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.ListWorkloadsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L99}
  /// [google.cloud.cloudcontrolspartner.v1.Workload]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::cloudcontrolspartner::v1::Workload> ListWorkloads(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists customer workloads for a given customer org id
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.ListWorkloadsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.Workload], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.ListWorkloadsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L99}
  /// [google.cloud.cloudcontrolspartner.v1.Workload]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customer_workloads.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::cloudcontrolspartner::v1::Workload> ListWorkloads(
      google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single customer
  ///
  /// @param name  Required. Format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.Customer]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L33}
  /// [google.cloud.cloudcontrolspartner.v1.GetCustomerRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L96}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Customer> GetCustomer(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single customer
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.GetCustomerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Customer])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.Customer]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L33}
  /// [google.cloud.cloudcontrolspartner.v1.GetCustomerRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L96}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Customer> GetCustomer(
      google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists customers of a partner identified by its Google Cloud organization ID
  ///
  /// @param parent  Required. Parent resource
  ///  Format: `organizations/{organization}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.Customer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.Customer]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L33}
  /// [google.cloud.cloudcontrolspartner.v1.ListCustomersRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L57}
  ///
  // clang-format on
  StreamRange<google::cloud::cloudcontrolspartner::v1::Customer> ListCustomers(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists customers of a partner identified by its Google Cloud organization ID
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.ListCustomersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.Customer], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.Customer]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L33}
  /// [google.cloud.cloudcontrolspartner.v1.ListCustomersRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/customers.proto#L57}
  ///
  // clang-format on
  StreamRange<google::cloud::cloudcontrolspartner::v1::Customer> ListCustomers(
      google::cloud::cloudcontrolspartner::v1::ListCustomersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the EKM connections associated with a workload
  ///
  /// @param name  Required. Format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/ekmConnections`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.EkmConnections])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.EkmConnections]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/ekm_connections.proto#L31}
  /// [google.cloud.cloudcontrolspartner.v1.GetEkmConnectionsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/ekm_connections.proto#L46}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
  GetEkmConnections(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the EKM connections associated with a workload
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.GetEkmConnectionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.EkmConnections])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.EkmConnections]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/ekm_connections.proto#L31}
  /// [google.cloud.cloudcontrolspartner.v1.GetEkmConnectionsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/ekm_connections.proto#L46}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
  GetEkmConnections(
      google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the partner permissions granted for a workload
  ///
  /// @param name  Required. Name of the resource to get in the format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}/partnerPermissions`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.PartnerPermissions])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetPartnerPermissionsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partner_permissions.proto#L66}
  /// [google.cloud.cloudcontrolspartner.v1.PartnerPermissions]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partner_permissions.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
  GetPartnerPermissions(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the partner permissions granted for a workload
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.GetPartnerPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.PartnerPermissions])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetPartnerPermissionsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partner_permissions.proto#L66}
  /// [google.cloud.cloudcontrolspartner.v1.PartnerPermissions]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partner_permissions.proto#L31}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
  GetPartnerPermissions(google::cloud::cloudcontrolspartner::v1::
                            GetPartnerPermissionsRequest const& request,
                        Options opts = {});

  // clang-format off
  ///
  /// @deprecated This RPC is deprecated.
  ///
  /// Deprecated: Only returns access approval requests directly associated with
  /// an assured workload folder.
  ///
  /// @param parent  Required. Parent resource
  ///  Format:
  ///  `organizations/{organization}/locations/{location}/customers/{customer}/workloads/{workload}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.AccessApprovalRequest], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.AccessApprovalRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/access_approval_requests.proto#L32}
  /// [google.cloud.cloudcontrolspartner.v1.ListAccessApprovalRequestsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/access_approval_requests.proto#L56}
  ///
  // clang-format on
  GOOGLE_CLOUD_CPP_DEPRECATED("This RPC is deprecated.")
  StreamRange<google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>
  ListAccessApprovalRequests(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// @deprecated This RPC is deprecated.
  ///
  /// Deprecated: Only returns access approval requests directly associated with
  /// an assured workload folder.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.ListAccessApprovalRequestsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cloudcontrolspartner.v1.AccessApprovalRequest], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.AccessApprovalRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/access_approval_requests.proto#L32}
  /// [google.cloud.cloudcontrolspartner.v1.ListAccessApprovalRequestsRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/access_approval_requests.proto#L56}
  ///
  // clang-format on
  GOOGLE_CLOUD_CPP_DEPRECATED("This RPC is deprecated.")
  StreamRange<google::cloud::cloudcontrolspartner::v1::AccessApprovalRequest>
  ListAccessApprovalRequests(
      google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Get details of a Partner.
  ///
  /// @param name  Required. Format:
  ///  `organizations/{organization}/locations/{location}/partner`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Partner])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetPartnerRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partners.proto#L69}
  /// [google.cloud.cloudcontrolspartner.v1.Partner]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partners.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Partner> GetPartner(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get details of a Partner.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cloudcontrolspartner.v1.GetPartnerRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cloudcontrolspartner.v1.Partner])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cloudcontrolspartner.v1.GetPartnerRequest]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partners.proto#L69}
  /// [google.cloud.cloudcontrolspartner.v1.Partner]: @googleapis_reference_link{google/cloud/cloudcontrolspartner/v1/partners.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::cloudcontrolspartner::v1::Partner> GetPartner(
      google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<CloudControlsPartnerCoreConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDCONTROLSPARTNER_V1_CLOUD_CONTROLS_PARTNER_CORE_CLIENT_H
