// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/job.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_JOB_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_JOB_TRACING_CONNECTION_H

#include "google/cloud/bigquerycontrol/v2/job_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquerycontrol_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class JobServiceTracingConnection
    : public bigquerycontrol_v2::JobServiceConnection {
 public:
  ~JobServiceTracingConnection() override = default;

  explicit JobServiceTracingConnection(
      std::shared_ptr<bigquerycontrol_v2::JobServiceConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::bigquery::v2::JobCancelResponse> CancelJob(
      google::cloud::bigquery::v2::CancelJobRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Job> GetJob(
      google::cloud::bigquery::v2::GetJobRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Job> InsertJob(
      google::cloud::bigquery::v2::InsertJobRequest const& request) override;

  Status DeleteJob(
      google::cloud::bigquery::v2::DeleteJobRequest const& request) override;

  StreamRange<google::cloud::bigquery::v2::ListFormatJob> ListJobs(
      google::cloud::bigquery::v2::ListJobsRequest request) override;

  StatusOr<google::cloud::bigquery::v2::GetQueryResultsResponse>
  GetQueryResults(google::cloud::bigquery::v2::GetQueryResultsRequest const&
                      request) override;

  StatusOr<google::cloud::bigquery::v2::QueryResponse> Query(
      google::cloud::bigquery::v2::PostQueryRequest const& request) override;

 private:
  std::shared_ptr<bigquerycontrol_v2::JobServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<bigquerycontrol_v2::JobServiceConnection>
MakeJobServiceTracingConnection(
    std::shared_ptr<bigquerycontrol_v2::JobServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquerycontrol_v2_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERYCONTROL_V2_INTERNAL_JOB_TRACING_CONNECTION_H
