// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/metadata_service.proto

#include "google/cloud/aiplatform/v1/metadata_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

MetadataServiceConnectionIdempotencyPolicy::
    ~MetadataServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<MetadataServiceConnectionIdempotencyPolicy>
MetadataServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<MetadataServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::CreateMetadataStore(
    google::cloud::aiplatform::v1::CreateMetadataStoreRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::GetMetadataStore(
    google::cloud::aiplatform::v1::GetMetadataStoreRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::ListMetadataStores(
    google::cloud::aiplatform::v1::ListMetadataStoresRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::DeleteMetadataStore(
    google::cloud::aiplatform::v1::DeleteMetadataStoreRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::CreateArtifact(
    google::cloud::aiplatform::v1::CreateArtifactRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::GetArtifact(
    google::cloud::aiplatform::v1::GetArtifactRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::ListArtifacts(
    google::cloud::aiplatform::v1::ListArtifactsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::UpdateArtifact(
    google::cloud::aiplatform::v1::UpdateArtifactRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::DeleteArtifact(
    google::cloud::aiplatform::v1::DeleteArtifactRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::PurgeArtifacts(
    google::cloud::aiplatform::v1::PurgeArtifactsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::CreateContext(
    google::cloud::aiplatform::v1::CreateContextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::GetContext(
    google::cloud::aiplatform::v1::GetContextRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::ListContexts(
    google::cloud::aiplatform::v1::ListContextsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::UpdateContext(
    google::cloud::aiplatform::v1::UpdateContextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::DeleteContext(
    google::cloud::aiplatform::v1::DeleteContextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::PurgeContexts(
    google::cloud::aiplatform::v1::PurgeContextsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
MetadataServiceConnectionIdempotencyPolicy::AddContextArtifactsAndExecutions(
    google::cloud::aiplatform::v1::
        AddContextArtifactsAndExecutionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::AddContextChildren(
    google::cloud::aiplatform::v1::AddContextChildrenRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::RemoveContextChildren(
    google::cloud::aiplatform::v1::RemoveContextChildrenRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
MetadataServiceConnectionIdempotencyPolicy::QueryContextLineageSubgraph(
    google::cloud::aiplatform::v1::QueryContextLineageSubgraphRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::CreateExecution(
    google::cloud::aiplatform::v1::CreateExecutionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::GetExecution(
    google::cloud::aiplatform::v1::GetExecutionRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::ListExecutions(
    google::cloud::aiplatform::v1::ListExecutionsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::UpdateExecution(
    google::cloud::aiplatform::v1::UpdateExecutionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::DeleteExecution(
    google::cloud::aiplatform::v1::DeleteExecutionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::PurgeExecutions(
    google::cloud::aiplatform::v1::PurgeExecutionsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::AddExecutionEvents(
    google::cloud::aiplatform::v1::AddExecutionEventsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
MetadataServiceConnectionIdempotencyPolicy::QueryExecutionInputsAndOutputs(
    google::cloud::aiplatform::v1::
        QueryExecutionInputsAndOutputsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::CreateMetadataSchema(
    google::cloud::aiplatform::v1::CreateMetadataSchemaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::GetMetadataSchema(
    google::cloud::aiplatform::v1::GetMetadataSchemaRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency MetadataServiceConnectionIdempotencyPolicy::ListMetadataSchemas(
    google::cloud::aiplatform::v1::ListMetadataSchemasRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
MetadataServiceConnectionIdempotencyPolicy::QueryArtifactLineageSubgraph(
    google::cloud::aiplatform::v1::QueryArtifactLineageSubgraphRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<MetadataServiceConnectionIdempotencyPolicy>
MakeDefaultMetadataServiceConnectionIdempotencyPolicy() {
  return std::make_unique<MetadataServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
