// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/deployment_resource_pool_service.proto

#include "google/cloud/aiplatform/v1/deployment_resource_pool_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeploymentResourcePoolServiceClient::DeploymentResourcePoolServiceClient(
    std::shared_ptr<DeploymentResourcePoolServiceConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
DeploymentResourcePoolServiceClient::~DeploymentResourcePoolServiceClient() =
    default;

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceClient::CreateDeploymentResourcePool(
    std::string const& parent,
    google::cloud::aiplatform::v1::DeploymentResourcePool const&
        deployment_resource_pool,
    std::string const& deployment_resource_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest request;
  request.set_parent(parent);
  *request.mutable_deployment_resource_pool() = deployment_resource_pool;
  request.set_deployment_resource_pool_id(deployment_resource_pool_id);
  return connection_->CreateDeploymentResourcePool(request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceClient::CreateDeploymentResourcePool(
    NoAwaitTag, std::string const& parent,
    google::cloud::aiplatform::v1::DeploymentResourcePool const&
        deployment_resource_pool,
    std::string const& deployment_resource_pool_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest request;
  request.set_parent(parent);
  *request.mutable_deployment_resource_pool() = deployment_resource_pool;
  request.set_deployment_resource_pool_id(deployment_resource_pool_id);
  return connection_->CreateDeploymentResourcePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceClient::CreateDeploymentResourcePool(
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDeploymentResourcePool(request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceClient::CreateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDeploymentResourcePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceClient::CreateDeploymentResourcePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateDeploymentResourcePool(operation);
}

StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceClient::GetDeploymentResourcePool(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::GetDeploymentResourcePoolRequest request;
  request.set_name(name);
  return connection_->GetDeploymentResourcePool(request);
}

StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceClient::GetDeploymentResourcePool(
    google::cloud::aiplatform::v1::GetDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDeploymentResourcePool(request);
}

StreamRange<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceClient::ListDeploymentResourcePools(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::ListDeploymentResourcePoolsRequest request;
  request.set_parent(parent);
  return connection_->ListDeploymentResourcePools(request);
}

StreamRange<google::cloud::aiplatform::v1::DeploymentResourcePool>
DeploymentResourcePoolServiceClient::ListDeploymentResourcePools(
    google::cloud::aiplatform::v1::ListDeploymentResourcePoolsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListDeploymentResourcePools(std::move(request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceClient::UpdateDeploymentResourcePool(
    google::cloud::aiplatform::v1::DeploymentResourcePool const&
        deployment_resource_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest request;
  *request.mutable_deployment_resource_pool() = deployment_resource_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDeploymentResourcePool(request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceClient::UpdateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeploymentResourcePool const&
        deployment_resource_pool,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest request;
  *request.mutable_deployment_resource_pool() = deployment_resource_pool;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDeploymentResourcePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceClient::UpdateDeploymentResourcePool(
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDeploymentResourcePool(request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceClient::UpdateDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDeploymentResourcePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeploymentResourcePool>>
DeploymentResourcePoolServiceClient::UpdateDeploymentResourcePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDeploymentResourcePool(operation);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceClient::DeleteDeploymentResourcePool(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest request;
  request.set_name(name);
  return connection_->DeleteDeploymentResourcePool(request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceClient::DeleteDeploymentResourcePool(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest request;
  request.set_name(name);
  return connection_->DeleteDeploymentResourcePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceClient::DeleteDeploymentResourcePool(
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDeploymentResourcePool(request);
}

StatusOr<google::longrunning::Operation>
DeploymentResourcePoolServiceClient::DeleteDeploymentResourcePool(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteDeploymentResourcePoolRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDeploymentResourcePool(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
DeploymentResourcePoolServiceClient::DeleteDeploymentResourcePool(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteDeploymentResourcePool(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
