
/* Domains */
typedef struct {
       const char *str;        /* domain name   */
       const char *expl;       /* Explanation   */
} DOM;

static DOM topdom[] = {
{ "COM" , "Commercial entity"                    ,} ,
{ "EDU" , "Educational institutions"             ,} ,
{ "NET" , "Network providers"                    ,} ,
{ "ORG" , "Organizations"                        ,} ,
{ "INT" , "International treaties, or databases" ,} ,
{ "GOV" , "Government"                           ,} ,
{ "MIL" , "Military"                             ,} ,
{ "FIRM", "Businesses or firms"                  ,} ,
{ "SHOP", "Businesses offering goods to purchase",} ,
{ "WEB" , "World Wide Web entities"              ,} ,
{ "ARTS", "Cultural and entertainment entities"  ,} ,
{ "REC" , "Recreation/entertainment entities"    ,} ,
{ "INFO", "Information services"                 ,} ,
{ "NOM" , "Individual or personal nomenclature"  ,} ,
{ " "   , " "                                    ,} ,
};

/* Sub domains */
static DOM subdom[] = {
{ "AC"    , "Academic establishments and organizations",} ,
{ "CO"    , "Companies or commercial organization"     ,} ,
{ "CS"    , "Computer science"                         ,} ,
{ "GW"    , "Gateway"                                  ,} ,
{ "GOPHER", "Internet Gopher"                          ,} ,
{ "FTP"   , "File Transfer Protocol"                   ,} ,
{ "LTD"   , "Private limited"                          ,} ,
{ "MAIL"  , "Mail services SMTP"                       ,} ,
{ "NNTP"  , "Network News Transfer Protocol"           ,} ,
{ "NEWS"  , "Network News Transfer Protocol"           ,} ,
{ "NS"    , "Name server"                              ,} ,
{ "NS1"   , "Name server"                              ,} ,
{ "NS2"   , "Name server"                              ,} ,
{ "PLC"   , "Public limited"                           ,} ,
{ "POP"   , "Post Office Protocol"                     ,} ,
{ "POP3"  , "Post Office Protocol, version 3"          ,} ,
{ "PROXY" , "Proxy server"                             ,} ,
{ "SMTP"  , "Simple Mail Transfer Protocol"            ,} ,
{ "SSH"   , "Secure Shell service"                     ,} ,
{ "WEB"   , "World Wide Web HTTP"                      ,} ,
{ "WWW"   , "World Wide Web HTTP"                      ,} ,
{ "WWW2"  , "World Wide Web HTTP"                      ,} ,
{ " "     , " "                                        ,} ,
};

/* iso 3166 Country codes struct */
typedef struct {
       const char *country;       /* Country name      */
       const char codes2l[ 2];    /* 2 letters codes   */
       const char codes3l[ 3];    /* 3 letters codes   */
       unsigned short int number; /* Number of country */
} ISO3166CCS;

static ISO3166CCS isoccs[] = {
{ "Afghanistan, Islamic State of"               , "af", "afg",    4,} ,
{ "African Intellectual Property Organization"  , "oa", "   ",    0,} ,
{ "African Regional Industrial "
  "Property Organization"                       , "ap", "   ",    0,} ,
{ "Åland"                                       , "ax", "ala",  248,} ,
{ "Albania"                                     , "al", "alb",    8,} ,
{ "Algeria"                                     , "dz", "dza",   12,} ,
{ "American Samoa"                              , "as", "asm",   16,} ,
{ "Andorra, Pricipality of"                     , "ad", "and",   20,} ,
{ "Angola, Republic of"                         , "ao", "ago",   24,} ,
{ "Anguilla"                                    , "ai", "aia",  660,} ,
{ "Antarctica"                                  , "aq", "ata",   10,} ,
{ "Antigua and Barbuda"                         , "ag", "atg",   28,} ,
{ "Argentina"                                   , "ar", "arg",   32,} ,
{ "Argentina (indeterminately reserved)"        , "ra", "   ",    0,} ,
{ "Armenia"                                     , "am", "arm",   51,} ,
{ "Aruba"                                       , "aw", "abw",  533,} ,
{ "Ascension Island"                            , "ac", "   ",    0,} ,
{ "Australia"                                   , "au", "aus",   36,} ,
{ "Austria"                                     , "at", "aut",   40,} ,
{ "Azerbaijan"                                  , "az", "aze",   31,} ,
{ "Bahamas"                                     , "bs", "bhs",   44,} ,
{ "Bahrain"                                     , "bh", "bhr",   48,} ,
{ "Bailiwicks of Guernsey (exceptionally "
  "reserved)"                                   , "gg", "   ",    0,} ,
{ "Bangladesh"                                  , "bd", "bgd",   50,} ,
{ "Barbados"                                    , "bb", "brb",   52,} ,
{ "Belarus"                                     , "by", "blr",  112,} ,
{ "Belgium"                                     , "be", "bel",   56,} ,
{ "Belize"                                      , "bz", "blz",   84,} ,
{ "Benelux Trademarks and Designs Office"       , "bx", "   ",    0,} ,
{ "Benin"                                       , "bj", "ben",  204,} ,
{ "Benin (indeterminately reserved)"            , "dy", "   ",    0,} ,
{ "Bermuda"                                     , "bm", "bmu",   60,} ,
{ "Bhutan"                                      , "bt", "btn",   64,} ,
{ "Bolivia, Plurinational State of"             , "bo", "bol",   68,} ,
{ "Bolivia (cf. Botswana: identical code "
  "element) (indeterminately reserved)"         , "rb", "   ",    0,} ,
{ "Bonaire, Sint Eustatius and Saba (Caribbean "
  "Netherlands"                                 , "bq", "bes",  535,} ,
{ "Bosnia and Herzegovina"                      , "ba", "bih",   70,} ,
{ "Botswana"                                    , "bw", "bwa",   72,} ,
{ "Bouvet Island"                               , "bv", "bvt",   74,} ,
{ "Brazil"                                      , "br", "bra",   76,} ,
{ "British Indian Ocean Territory"              , "io", "iot",   86,} ,
{ "Brunei Darussalam"                           , "bn", "brn",   96,} ,
{ "Bulgaria"                                    , "bg", "bgr",  100,} ,
{ "Burkina Faso"                                , "bf", "bfa",  854,} ,
{ "Burma (transitionally reserved)"             , "bu", "   ",    0,} ,
{ "Burundi"                                     , "bi", "bdi",  108,} ,
{ "Cambodia, Kingdom of"                        , "kh", "khm",  116,} ,
{ "Cameroon"                                    , "cm", "cmr",  120,} ,
{ "Canada"                                      , "ca", "can",  124,} ,
{ "Canary Islands (exceptionally reserved)"     , "ic", "   ",    0,} ,
{ "Cape Verde"                                  , "cv", "cpv",  132,} ,
{ "Cayman Islands"                              , "ky", "cym",  136,} ,
{ "Central African Republic"                    , "cf", "caf",  140,} ,
{ "Ceuta, Melilla (exceptionally reserved)"     , "ea", "   ",    0,} ,
{ "Chad"                                        , "td", "tcd",  148,} ,
{ "Chile"                                       , "cl", "chl",  152,} ,
{ "China"                                       , "cn", "chn",  156,} ,
{ "China (indeterminately reserved)"            , "rc", "   ",    0,} ,
{ "Christmas Island"                            , "cx", "cxr",  162,} ,
{ "Clipperton Island (exceptionally reserved)"  , "cp", "   ",    0,} ,
{ "Cocos (Keeling) Islands"                     , "cc", "cck",  166,} ,
{ "Colombia"                                    , "co", "col",  170,} ,
{ "Comoros"                                     , "km", "com",  174,} ,
{ "Congo"                                       , "cg", "cog",  178,} ,
{ "Congo, The Democratic Republic of the"       , "cd", "cod",  180,} ,
{ "Cook Islands"                                , "ck", "cok",  184,} ,
{ "Costa Rica"                                  , "cr", "cri",  188,} ,
{ "Cote D'Ivoire (Ivory Coast)"                 , "ci", "civ",  384,} ,
{ "Croatia (Hrvatska)"                          , "hr", "hrv",  191,} ,
{ "Cuba"                                        , "cu", "cub",  192,} ,
{ "Curaçao"                                     , "cw", "cuw",  531,} ,
{ "Cyprus"                                      , "cy", "cyp",  196,} ,
{ "Czech Republic"                              , "cz", "cze",  203,} ,
{ "Denmark"                                     , "dk", "dnk",  208,} ,
{ "Diego Garcia (exceptionally reserved)"       , "dg", "   ",    0,} ,
{ "Djibouti"                                    , "dj", "dji",  262,} ,
{ "Dominica"                                    , "dm", "dma",  212,} ,
{ "Dominican Republic"                          , "do", "dom",  214,} ,
{ "East Timor (transitionally reserved)"        , "tp", "tmp",  626,} ,
{ "Ecuador"                                     , "ec", "ecu",  218,} ,
{ "Egypt"                                       , "eg", "egy",  818,} ,
{ "El Salvador"                                 , "sv", "slv",  222,} ,
{ "Equatorial Guinea"                           , "gq", "gnq",  226,} ,
{ "Eritrea"                                     , "er", "eri",  232,} ,
{ "Estonia"                                     , "ee", "est",  233,} ,
{ "Estonia (indeterminately reserved)"          , "ew", "   ",    0,} ,
{ "Ethiopia"                                    , "et", "eth",  231,} ,
{ "Eurasian Patent Organization (not used)"     , "ev", "   ",    0,} ,
{ "European Patent Organization (not used)"     , "ep", "   ",    0,} ,
{ "European Trademark Office (not used)"        , "em", "   ",    0,} ,
{ "European Union (exceptionally reserved)"     , "eu", "   ",    0,} ,
{ "Falkland Islands (Malvinas)"                 , "fk", "flk",  238,} ,
{ "Faroe Islands"                               , "fo", "fro",  234,} ,
{ "Fiji"                                        , "fj", "fji",  242,} ,
{ "Finland"                                     , "fi", "fin",  246,} ,
{ "Finland (transitionally reserved)"           , "sf", "   ",    0,} ,
{ "France"                                      , "fr", "fra",  250,} ,
{ "France, Metropolitan (exceptionally "
  "reserved)"                                   , "fx", "fxx",  249,} ,
{ "French Guiana"                               , "gf", "guf",  254,} ,
{ "French Polynesia"                            , "pf", "pyf",  258,} ,
{ "French Southern Territories"                 , "tf", "atf",  260,} ,
{ "Gabon"                                       , "ga", "gab",  266,} ,
{ "Gambia"                                      , "gm", "gmb",  270,} ,
{ "Georgia"                                     , "ge", "geo",  268,} ,
{ "Germany"                                     , "de", "deu",  276,} ,
{ "Ghana"                                       , "gh", "gha",  288,} ,
{ "Gibraltar"                                   , "gi", "gib",  292,} ,
{ "Greece"                                      , "gr", "grc",  300,} ,
{ "Greenland"                                   , "gl", "grl",  304,} ,
{ "Grenada"                                     , "gd", "grd",  308,} ,
{ "Grenada (indeterminately reserved)"          , "wg", "   ",    0,} ,
{ "Guadeloupe"                                  , "gp", "glp",  312,} ,
{ "Guam"                                        , "gu", "gum",  316,} ,
{ "Guatemala"                                   , "gt", "gtm",  320,} ,
{ "Guinea"                                      , "gn", "gin",  324,} ,
{ "Guinea-Bissau"                               , "gw", "gnb",  624,} ,
{ "Guyana"                                      , "gy", "guy",  328,} ,
{ "Haiti"                                       , "ht", "hti",  332,} ,
{ "Haiti (indeterminately reserved)"            , "rh", "   ",    0,} ,
{ "Heard and MC Donald Islands"                 , "hm", "hmd",  334,} ,
{ "Holy See (Vatican City State)"               , "va", "vat",  336,} ,
{ "Honduras"                                    , "hn", "hnd",  340,} ,
{ "Hong kong"                                   , "hk", "hkg",  344,} ,
{ "Hungary"                                     , "hu", "hun",  348,} ,
{ "Iceland"                                     , "is", "isl",  352,} ,
{ "India"                                       , "in", "ind",  356,} ,
{ "Indonesia"                                   , "id", "idn",  360,} ,
{ "Indonesia (indeterminately reserved)"        , "ri", "   ",    0,} ,
{ "International Bureau of WIPO "
  "(indeterminately reserved)"                  , "ib", "   ",    0,} ,
{ "Iran, Islamic Republic of"                   , "ir", "irn",  364,} ,
{ "Iraq"                                        , "iq", "irq",  368,} ,
{ "Ireland"                                     , "ie", "irl",  372,} ,
{ "Isle of Man"                                 , "im", "imn",  833,} ,
{ "Israel"                                      , "il", "isr",  376,} ,
{ "Italy"                                       , "it", "ita",  380,} ,
{ "Jamaica"                                     , "jm", "jam",  388,} ,
{ "Jamaica (indeterminately reserved)"          , "ja", "   ",    0,} ,
{ "Japan"                                       , "jp", "jpn",  392,} ,
{ "Jersey"                                      , "je", "jey",  832,} ,
{ "Jordan"                                      , "jo", "jor",  400,} ,
{ "Kazakhstan"                                  , "kz", "kaz",  398,} ,
{ "Kenya"                                       , "ke", "ken",  404,} ,
{ "Kiribati"                                    , "ki", "kir",  296,} ,
{ "Korea, Democratic People's Republic of"      , "kp", "prk",  408,} ,
{ "Korea, Republic of"                          , "kr", "kor",  410,} ,
{ "Kuwait"                                      , "kw", "kwt",  414,} ,
{ "Kyrgyzstan (Kyrgyz Republic)"                , "kg", "kgz",  417,} ,
{ "Lao People's Democratic Republic"            , "la", "lao",  418,} ,
{ "Latvia"                                      , "lv", "lva",  428,} ,
{ "Lebanon"                                     , "lb", "lbn",  422,} ,
{ "Lebanon (indeterminately reserved)"          , "rl", "   ",    0,} ,
{ "Lesotho"                                     , "ls", "lso",  426,} ,
{ "Liberia"                                     , "lr", "lbr",  430,} ,
{ "Libya"                                       , "ly", "lby",  434,} ,
{ "Libya Fezzan (indeterminately reserved)"     , "lf", "   ",    0,} ,
{ "Liechtenstein"                               , "li", "lie",  438,} ,
{ "Liechtenstein (indeterminately reserved)"    , "fl", "   ",    0,} ,
{ "Lithuania"                                   , "lt", "ltu",  440,} ,
{ "Luxembourg"                                  , "lu", "lux",  442,} ,
{ "Macau"                                       , "mo", "mac",  446,} ,
{ "Macedonia, the former Yugoslav Republic of"  , "mk", "mkd",  807,} ,
{ "Madagascar (indeterminately reserved)"       , "rm", "   ",    0,} ,
{ "Madagascar, Republic of"                     , "mg", "mdg",  450,} ,
{ "Malawi"                                      , "mw", "mwi",  454,} ,
{ "Malaysia"                                    , "my", "mys",  458,} ,
{ "Maldives"                                    , "mv", "mdv",  462,} ,
{ "Mali"                                        , "ml", "mli",  466,} ,
{ "Malta"                                       , "mt", "mlt",  470,} ,
{ "Marshall Islands"                            , "mh", "mhl",  584,} ,
{ "Martinique"                                  , "mq", "mtq",  474,} ,
{ "Mauritania"                                  , "mr", "mrt",  478,} ,
{ "Mauritius"                                   , "mu", "mus",  480,} ,
{ "Mayotte"                                     , "yt", "myt",  175,} ,
{ "Mexico"                                      , "mx", "mex",  484,} ,
{ "Micronesia, Federated States of"             , "fm", "fsm",  583,} ,
{ "Moldova, Republic of"                        , "md", "mda",  498,} ,
{ "Monaco"                                      , "mc", "mco",  492,} ,
{ "Mongolia"                                    , "mn", "mng",  496,} ,
{ "Montenegro"                                  , "me", "mne",  499,} ,
{ "Montserrat"                                  , "ms", "msr",  500,} ,
{ "Morocco"                                     , "ma", "mar",  504,} ,
{ "Mozambique"                                  , "mz", "moz",  508,} ,
{ "Myanmar"                                     , "mm", "mmr",  104,} ,
{ "Namibia"                                     , "na", "nam",  516,} ,
{ "Nauru"                                       , "nr", "nru",  520,} ,
{ "Nepal"                                       , "np", "npl",  524,} ,
{ "Netherlands"                                 , "nl", "nld",  528,} ,
{ "Netherlands Antilles (transitionally "
  "reserved)"                                   , "an", "   ",    0,} ,
{ "Neutral Zone (transitionally reserved)"      , "nt", "   ",    0,} ,
{ "New Caledonia"                               , "nc", "ncl",  540,} ,
{ "New Zealand"                                 , "nz", "nzl",  554,} ,
{ "Nicaragua"                                   , "ni", "nic",  558,} ,
{ "Niger"                                       , "ne", "ner",  562,} ,
{ "Niger (indeterminately reserved)"            , "rn", "   ",    0,} ,
{ "Nigeria"                                     , "ng", "nga",  566,} ,
{ "Niue"                                        , "nu", "niu",  570,} ,
{ "Norfolk Island"                              , "nf", "nfk",  574,} ,
{ "Northern Mariana Islands"                    , "mp", "mnp",  580,} ,
{ "Norway"                                      , "no", "nor",  578,} ,
{ "Oman"                                        , "om", "omn",  512,} ,
{ "Pakistan"                                    , "pk", "pak",  586,} ,
{ "Palau"                                       , "pw", "plw",  585,} ,
{ "Palestinian, State of"                       , "ps", "pse",  275,} ,
{ "Panama"                                      , "pa", "pan",  591,} ,
{ "Papua New Guinea"                            , "pg", "png",  598,} ,
{ "Paraguay"                                    , "py", "pry",  600,} ,
{ "Patent Office of the Cooperation Council "
  "for the Arab States of the Gulf (GCC)"       , "gc", "   ",    0,} ,
{ "Peru"                                        , "pe", "per",  604,} ,
{ "Philippines"                                 , "ph", "phl",  608,} ,
{ "Philippines (indeterminately reserved)"      , "pi", "   ",    0,} ,
{ "Philippines (indeterminately reserved)"      , "rp", "   ",    0,} ,
{ "Pitcairn"                                    , "pn", "pcn",  612,} ,
{ "Poland"                                      , "pl", "pol",  616,} ,
{ "Portugal"                                    , "pt", "prt",  620,} ,
{ "Puerto Rico"                                 , "pr", "pri",  630,} ,
{ "Qatar"                                       , "qa", "qat",  634,} ,
{ "Reunion"                                     , "re", "reu",  638,} ,
{ "Romania"                                     , "ro", "rom",  642,} ,
{ "Russian Federation"                          , "ru", "rus",  643,} ,
{ "Rwanda"                                      , "rw", "rwa",  646,} ,
{ "Saint Barthélemy"                            , "bl", "blm",  652,} ,
{ "Saint Helena, Ascension and Tristan da "
  "Cunha"                                       , "sh", "shn",  654,} ,
{ "Saint Kitts and Nevis"                       , "kn", "kna",  659,} ,
{ "Saint Lucia"                                 , "lc", "lca",  662,} ,
{ "Saint Lucia (indeterminately reserved)"      , "wl", "   ",    0,} ,
{ "Saint Martin (French part)"                  , "mf", "maf",  663,} ,
{ "Saint Pierre and Miquelon"                   , "pm", "spm",  666,} ,
{ "Saint Vincent (indeterminately reserved)"    , "wv", "   ",    0,} ,
{ "Saint Vincent and the Grenadines"            , "vc", "vct",  670,} ,
{ "Samoa"                                       , "ws", "wsm",  882,} ,
{ "San Marino"                                  , "sm", "smr",  674,} ,
{ "Sao Tome and Principe"                       , "st", "stp",  678,} ,
{ "Saudi Arabia"                                , "sa", "sau",  682,} ,
{ "Senegal"                                     , "sn", "sen",  686,} ,
{ "Serbia"                                      , "rs", "srb",  688,} ,
{ "Serbia and Montenegro (transitionally "
  "reserved)"                                   , "cs", "   ",    0,} ,
{ "Seychelles"                                  , "sc", "syc",  690,} ,
{ "Sierra Leone"                                , "sl", "sle",  694,} ,
{ "Singapore"                                   , "sg", "sgp",  702,} ,
{ "Sint Maarten (Dutch part)"                   , "sx", "sxm",  534,} ,
{ "Slovakia"                                    , "sk", "svk",  703,} ,
{ "Slovenia"                                    , "si", "svn",  705,} ,
{ "Solomon Islands"                             , "sb", "slb",   90,} ,
{ "Somalia"                                     , "so", "som",  706,} ,
{ "South Africa"                                , "za", "zaf",  710,} ,
{ "South Georgia and the South Sandwich Islands", "gs", "sgs",  239,} ,
{ "South Sudan"                                 , "ss", "ssd",  728,} ,
{ "Spain"                                       , "es", "esp",  724,} ,
{ "Sri Lanka"                                   , "lk", "lka",  144,} ,
{ "Sudan"                                       , "sd", "sdn",  736,} ,
{ "Suriname"                                    , "sr", "sur",  740,} ,
{ "Svalbard and Jan Mayen Islands"              , "sj", "sjm",  744,} ,
{ "Swaziland"                                   , "sz", "swz",  748,} ,
{ "Sweden"                                      , "se", "swe",  752,} ,
{ "Switzerland"                                 , "ch", "che",  756,} ,
{ "Syrian Arab Republic"                        , "sy", "syr",  760,} ,
{ "Taiwan, Province of China"                   , "tw", "twn",  158,} ,
{ "Tajikistan"                                  , "tj", "tjk",  762,} ,
{ "Tanzania, United Republic of"                , "tz", "tza",  834,} ,
{ "Thailand"                                    , "th", "tha",  764,} ,
{ "Timor-Leste"                                 , "tl", "tls",  626,} ,
{ "Togo"                                        , "tg", "tgo",  768,} ,
{ "Tokelau"                                     , "tk", "tkl",  772,} ,
{ "Tonga"                                       , "to", "ton",  776,} ,
{ "Trinidad and Tobago"                         , "tt", "tto",  780,} ,
{ "Tristan da Cunha (exceptionally reserved)"   , "ta", "   ",    0,} ,
{ "Tunisia"                                     , "tn", "tun",  788,} ,
{ "Turkey"                                      , "tr", "tur",  792,} ,
{ "Turkmenistan"                                , "tm", "tkm",  795,} ,
{ "Turks and Caicos Islands"                    , "tc", "tca",  796,} ,
{ "Tuvalu"                                      , "tv", "tuv",  798,} ,
{ "Uganda"                                      , "ug", "uga",  800,} ,
{ "Ukraine"                                     , "ua", "ukr",  804,} ,
{ "Union of Countries under the European "
  "Community Patent Convention (not used)"      , "ef", "   ",    0,} ,
{ "United Arab Emirates"                        , "ae", "are",  784,} ,
{ "United Kingdom (exceptionally reserved)"     , "uk", "   ",    0,} ,
{ "United Kingdom"                              , "gb", "gbr",  826,} ,
{ "United States"                               , "us", "usa",  840,} ,
{ "United States minor outlying islands"        , "um", "umi",  581,} ,
{ "Uruguay"                                     , "uy", "ury",  858,} ,
{ "(user-assigned)"                             , "aa", "   ",    0,} ,
{ "(user-assigned) "                            , "qm", "   ",    0,} ,
{ "(user-assigned) "                            , "qn", "   ",    0,} ,
{ "(user-assigned) "                            , "qo", "   ",    0,} ,
{ "(user-assigned) "                            , "qp", "   ",    0,} ,
{ "(user-assigned) "                            , "qq", "   ",    0,} ,
{ "(user-assigned) "                            , "qr", "   ",    0,} ,
{ "(user-assigned) "                            , "qs", "   ",    0,} ,
{ "(user-assigned) "                            , "qt", "   ",    0,} ,
{ "(user-assigned) "                            , "qu", "   ",    0,} ,
{ "(user-assigned) "                            , "qv", "   ",    0,} ,
{ "(user-assigned) "                            , "qw", "   ",    0,} ,
{ "(user-assigned) "                            , "qx", "   ",    0,} ,
{ "(user-assigned) "                            , "qy", "   ",    0,} ,
{ "(user-assigned) "                            , "qz", "   ",    0,} ,
{ "(user-assigned) "                            , "xa", "   ",    0,} ,
{ "(user-assigned) "                            , "xb", "   ",    0,} ,
{ "(user-assigned) "                            , "xc", "   ",    0,} ,
{ "(user-assigned) "                            , "xd", "   ",    0,} ,
{ "(user-assigned) "                            , "xe", "   ",    0,} ,
{ "(user-assigned) "                            , "xf", "   ",    0,} ,
{ "(user-assigned) "                            , "xg", "   ",    0,} ,
{ "(user-assigned) "                            , "xh", "   ",    0,} ,
{ "(user-assigned) "                            , "xi", "   ",    0,} ,
{ "(user-assigned) "                            , "xj", "   ",    0,} ,
{ "(user-assigned) "                            , "xk", "   ",    0,} ,
{ "(user-assigned) "                            , "xl", "   ",    0,} ,
{ "(user-assigned) "                            , "xm", "   ",    0,} ,
{ "(user-assigned) "                            , "xn", "   ",    0,} ,
{ "(user-assigned) "                            , "xo", "   ",    0,} ,
{ "(user-assigned) "                            , "xp", "   ",    0,} ,
{ "(user-assigned) "                            , "xq", "   ",    0,} ,
{ "(user-assigned) "                            , "xr", "   ",    0,} ,
{ "(user-assigned) "                            , "xs", "   ",    0,} ,
{ "(user-assigned) "                            , "xt", "   ",    0,} ,
{ "(user-assigned) "                            , "xu", "   ",    0,} ,
{ "(user-assigned) "                            , "xv", "   ",    0,} ,
{ "(user-assigned) "                            , "xw", "   ",    0,} ,
{ "(user-assigned) "                            , "xx", "   ",    0,} ,
{ "(user-assigned) "                            , "xy", "   ",    0,} ,
{ "(user-assigned) "                            , "xz", "   ",    0,} ,
{ "(user-assigned) "                            , "zz", "   ",    0,} ,
{ "USSR (exceptionally reserved)"               , "su", "   ",    0,} ,
{ "Uzbekistan"                                  , "uz", "uzb",  860,} ,
{ "Vanuatu"                                     , "vu", "vut",  548,} ,
{ "Venezuela, Bolivarian Republic of"           , "ve", "ven",  862,} ,
{ "Venezuela (indeterminately reserved)"        , "yv", "   ",    0,} ,
{ "Viet Nam"                                    , "vn", "vnm",  704,} ,
{ "Virgin Islands (British)"                    , "vg", "vgb",   92,} ,
{ "Virgin Islands (U.S.)"                       , "vi", "vir",  850,} ,
{ "Wallis and Futuna Islands"                   , "wf", "wlf",  876,} ,
{ "Western Sahara"                              , "eh", "esh",  732,} ,
{ "World Intellectual Property Organization"    , "wo", "   ",    0,} ,
{ "Yemen"                                       , "ye", "yem",  887,} ,
{ "Yugoslavia (transitionally reserved)"        , "yu", "   ",    0,} ,
{ "Zaire (transitionally reserved)"             , "zr", "   ",    0,} ,
{ "Zambia"                                      , "zm", "zmb",  894,} ,
{ "Zimbabwe"                                    , "zw", "zwe",  716,} ,
{ " "                                           , "  ", "   ",    0,} ,
};

/* Search types */
#define ISO_SEARCH_COUNTRY 0
#define ISO_SEARCH_2L      1
#define ISO_SEARCH_3L      2
#define ISO_SEARCH_NUMBER  3

