/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * spherical invert v4
 * from M3D. Baded on formula by Luca GN 2011, updated May 2012.
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_spherical_inv_v4.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfSphericalInvV4Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 oldZ = z;
	REAL RR = 1.0f;
	z += fractal->mandelbox.offset;
	z *= fractal->transformCommon.scale;
	aux->DE = aux->DE * fabs(fractal->transformCommon.scale) + 1.0f;

	if (!fractal->transformCommon.functionEnabledyFalse)
		RR = dot(z, z);
	else
		RR = dot(oldZ, oldZ);
	REAL mde = RR;

	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP1)
	{
		mde = 1.0f / mde;
		z *= mde;
		aux->DE *= mde;
	}

	if (fractal->transformCommon.functionEnabled
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC1)
	{
		z += fractal->transformCommon.offset000;
		REAL mn = fractal->transformCommon.minR0;

		// modes
		if (fractal->transformCommon.functionEnabledFalse) // Mode 1
		{
			if (RR < fractal->transformCommon.minR0) mde = mn;
		}

		if (fractal->transformCommon.functionEnabledAFalse) // Mode 2
		{
			if (RR < fractal->mandelbox.foldingSphericalFixed) mde = mn;
		}

		if (fractal->transformCommon.functionEnabledBFalse) // Mode 3
		{
			if (RR < fractal->mandelbox.foldingSphericalFixed && RR > fractal->transformCommon.minR0)
				mde = mn;
			else if (RR > fractal->mandelbox.foldingSphericalFixed)
				mde = fractal->mandelbox.foldingSphericalFixed / RR;
		}

		if (fractal->transformCommon.functionEnabledFFalse) // Mode 6
		{
			if (RR < fractal->mandelbox.foldingSphericalFixed && RR > fractal->transformCommon.minR0)
				mde = mn;
			else if (RR > fractal->mandelbox.foldingSphericalFixed)
				mde = RR / fractal->mandelbox.foldingSphericalFixed;
		}

		if (fractal->transformCommon.functionEnabledDFalse) // Mode 5
		{
			if (RR > fractal->transformCommon.minR0) mde = mn;
		}

		if (fractal->transformCommon.functionEnabledCFalse) // Mode 4
		{
			if (RR < fractal->transformCommon.minR0) mde = mn;
			if (RR > fractal->mandelbox.foldingSphericalFixed)
				mde = fractal->mandelbox.foldingSphericalFixed;
		}

		mde = 1.0f / mde;
		z *= mde;
		aux->DE *= fabs(mde);
		z -= fractal->transformCommon.offset000;
	}
	z -= fractal->mandelbox.offset + fractal->transformCommon.additionConstant000;

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	}

	// color added v2.32
	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL addCol = 0.0f;
		addCol += fractal->foldColor.difs0000.x * mde;
		if (RR > fractal->mandelbox.foldingSphericalFixed) addCol += fractal->foldColor.difs0000.y;
		if (RR < fractal->transformCommon.minR0) addCol += fractal->foldColor.difs0000.z;

		//	aux->color = addCol;

		aux->color += addCol;
	}
	return z;
}