/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDifsBoxV2Iteration  fragmentarium code, mdifs by knighty (jan 2012)

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_box_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSBoxV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	z += fractal->transformCommon.offset000;
	REAL4 zc = z;
	REAL4 boxSize = fractal->transformCommon.additionConstant111;

	// curve
	if (fractal->transformCommon.functionEnabledTFalse
			&& aux->i >= fractal->transformCommon.startIterationsT
			&& aux->i < fractal->transformCommon.stopIterationsT)
	{
		REAL absZZ = zc.z * zc.z * fractal->transformCommon.scale0;
		boxSize.x += absZZ;
		boxSize.y += absZZ;
	}

	// pyramid
	if (fractal->transformCommon.functionEnabledMFalse
			&& aux->i >= fractal->transformCommon.startIterationsM
			&& aux->i < fractal->transformCommon.stopIterationsM)
	{
		REAL subZ = fractal->transformCommon.scaleA0 * zc.z;
		boxSize.x -= subZ;
		boxSize.y -= subZ;
	}

	REAL4 q = fabs(zc) - boxSize;
	zc.x = max(q.x, 0.0f);
	zc.y = max(q.y, 0.0f);
	zc.z = max(q.z, 0.0f);
	REAL zcd = length(zc);

	REAL colDist = aux->dist;
	aux->dist = min(aux->dist, zcd / (aux->DE + 1.0f));

	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		if (!fractal->foldColor.auxColorEnabledAFalse)
		{
			if (colDist != aux->dist) aux->color += fractal->foldColor.difs0000.x;
		}
		else
		{
			if (fractal->foldColor.difs0000.y != 0.0f && zc.x == fabs(q.x))
				aux->color += fractal->foldColor.difs0000.y;
			if (fractal->foldColor.difs0000.z != 0.0f && zc.y == fabs(q.y))
				aux->color += fractal->foldColor.difs0000.z;
			if (fractal->foldColor.difs0000.w != 0.0f && zc.z == fabs(q.z))
				aux->color += fractal->foldColor.difs0000.w;

			if (fractal->foldColor.difs0 != 0.0f)
			{
				REAL t = z.x * z.y;
				if ((t > 0.0f && z.z > 0.0f) || (t < 0.0f && z.z < 0.0f))
					aux->color += fractal->foldColor.difs0;
			}
		}
	}
	return z;
}