/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2024 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * benesiFastPwr2PineTree 3D
 * @reference
 * http://www.fractalforums.com/new-theories-and-research/
 * do-m3d-formula-have-to-be-distance-estimation-formulas/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_benesi_pine_tree.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 BenesiPineTreeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	aux->DE = aux->r * aux->DE * 2.0f + 1.0f;

	REAL4 temp = z;

	z *= z;
	REAL t = z.y + z.z;
	z.x -= t;

	if (t > 0.0f)
	{
		temp.x = 2.0f * temp.x / native_sqrt(t);
		z.z = temp.x * (z.y - z.z);
		z.y = 2.0f * temp.x * temp.y * temp.z;
	}
	else
	{
		z.z = z.y - z.z;
		z.y = 2.0f * temp.y * temp.z;
	}

	z.x += aux->const_c.x * fractal->transformCommon.constantMultiplier100.x;
	// c.yz swap
	z.z += aux->const_c.y * fractal->transformCommon.constantMultiplier100.y;
	z.y += aux->const_c.z * fractal->transformCommon.constantMultiplier100.z;

	if (fractal->transformCommon.angle0 != 0)
	{
		temp.y = z.y;
		t = fractal->transformCommon.angle0 * M_PI_180_F;
		temp.x = native_sin(t);
		temp.z = native_cos(t);
		z.y = z.y * temp.z + z.z * temp.x;
		z.z = temp.y * -temp.x + z.z * temp.z;
	}
	return z;
}