/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * amazing surf from Mandelbulber3D. Formula proposed by Kali, with features added by DarkBeam
 *
 * This formula has a c.x c.y SWAP
 *
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_amazing_surf.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 AmazingSurfIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	// update aux->actualScale
	aux->actualScale =
		fractal->mandelbox.scale + fractal->mandelboxVary4D.scaleVary * (fabs(aux->actualScale) - 1.0f);

	REAL4 c = aux->const_c;
	z.x = fabs(z.x + fractal->transformCommon.additionConstant111.x)
				- fabs(z.x - fractal->transformCommon.additionConstant111.x) - z.x;
	z.y = fabs(z.y + fractal->transformCommon.additionConstant111.y)
				- fabs(z.y - fractal->transformCommon.additionConstant111.y) - z.y;
	// no z fold

	REAL rr = dot(z, z);
	if (fractal->transformCommon.functionEnabledFalse) // force cylinder fold
		rr -= z.z * z.z;

	REAL sqrtMinR = native_sqrt(fractal->transformCommon.minR05);
	REAL dividend = rr < sqrtMinR ? sqrtMinR : min(rr, 1.0f);

	/*if (rr < sqrtMinR)
	{
		aux->color += fractal->mandelbox.color.factorSp1;
	}
	else if (rr < 1.0f)
	{
		aux->color += fractal->mandelbox.color.factorSp2;
	}*/
	// use aux->actualScale
	REAL m = aux->actualScale / dividend;

	z *= (m - 1.0f) * fractal->transformCommon.scale1 + 1.0f;
	// z *= m * fractal->transformCommon.scale1 + 1.0f * (1.0f - fractal->transformCommon.scale1);
	aux->DE = aux->DE * fabs(m) + 1.0f;

	if (fractal->transformCommon.addCpixelEnabledFalse)
		z += (REAL4){c.y, c.x, c.z, c.w} * fractal->transformCommon.constantMultiplier111;

	z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	return z;
}