/*  checkboxes.c: (c) 2002 sibn

    This file is part of GWiz.

    GWiz is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GWiz is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GWiz; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <dlfcn.h>
#include <stdlib.h>
#include "gwiz.h"
#include "prefsdat.h"
#include "text.h"
#include "uiloop.h"
#include "maploader.h"
#include "menus.h"
#include "checkboxes.h"

extern GwizApp gwiz;

GwizCheckBoxList NewGwizCheckBoxList (SDL_Surface *on, SDL_Surface *off, 
				      int alignment, int members)
{
	GwizCheckBoxList cbl;
	SDL_Rect dest;
	int i;

	cbl.on = on;
	cbl.off = off;
	cbl.width = 0;
	cbl.height = 0;
	/* FIXME:  Need to accomodate horizontal boxes as well */
	cbl.alignment = alignment;
	cbl.members = members;
	dest.x = 8;
	dest.y = 8;
	dest.h = on->h;
	dest.w = on->w;

	/* need to know how wide the frame should be */
	for (i = 0; i < members; i++)
	{
		if (on->w > cbl.width)
			cbl.width = on->w;
		if (off->w > cbl.width)
			cbl.width = off->w;
	}

	cbl.height = cbl.members * gwiz.font.height;

	cbl.area = NewTextBox (cbl.width, cbl.height);

	for (i = 0; i < members; i++)
	{
		SDL_BlitSurface (on, NULL, cbl.area, &dest);
		dest.y++;
	}

	dest.x = 0;
	dest.y = 0;
	dest.h = cbl.area->h;
	dest.w = cbl.area->w;

	SDL_UpdateRects (cbl.area, 1, &dest);

	return (cbl);
}

void SetCheckBoxInList (GwizCheckBoxList *list, int member, int value)
{
	SDL_Rect dest;
	dest.x = 8;
	dest.y += gwiz.font.height * (member-1) + 8;
	dest.h = gwiz.font.height;
	dest.w = list->area->w - 16; /* remember the frame */

	if ((member > list->members) || (member < 1))
	{
		fprintf (stderr, "Warning: Asked to toggle unknown switch");
		return;
	}

	switch (value)
	{
	case 0:
		SDL_BlitSurface (list->off, NULL, list->area, &dest);
		SDL_UpdateRects (list->area, 1, &dest);
		break;
	case 1:
		SDL_BlitSurface (list->on, NULL, list->area, &dest);
		SDL_UpdateRects (list->area, 1, &dest);
		break;
	}
}








