#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>

#include "qmrtg-utils.h"

/* up to hundred of megabytes supported */
#define MAX_BYTESTR_LEN     10

#define NEEDLE              ": bytes "
#define NEEDLE_LEN          8


int main() {
    char line[MAX_LOGLINE_LEN];
    char *startptr, *endptr;
    char val[MAX_BYTESTR_LEN];
    unsigned long bytes = 0;
    
    
    while ( fgets(line, MAX_LOGLINE_LEN, stdin) != NULL ) {
        /* do we care about this line? */
        if ((startptr = strstr(line, NEEDLE)) == NULL) continue;

        /* so, extracting the number of bytes */
        startptr += NEEDLE_LEN;  /* ": bytes " */
        endptr = strchr(startptr, ' ');
        if (endptr == NULL) continue;
        memcpy(val, startptr, endptr - startptr);
        val[endptr - startptr] = '\0';
        
        bytes += (unsigned long)strtol(val, (char **)NULL, 10);
    }

    printf("%lu\n%lu\n", bytes, (unsigned long)0);
    
    
    return 0;
}
