/********************************************************************************
* File:   		wepdecrypt.c
* Date:   		2002-09-24
* Author: 		Alain Girardet/Dominik Blunk/Fernando Tarin
* Last Modified:	3-02-2005
*
*
* Description: Read guessed passwords from stdin and applies RC4
* on sniffed encrypted 802.11 DATA packets
*
* This program is free software; you can redistribute it and/or modify it under
* the terms of the GNU General Public License as published by the Free Software
* Foundation; either version 2 of the License, or (at your option) any later
* version. See http://www.fsf.org/copyleft/gpl.txt.
*
* This program is distributed in the hope that it will be useful, but WITHOUT ANY
* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
* PARTICULAR PURPOSE. See the GNU General Public License for more details.
*
********************************************************************************/

#include <time.h>
#include <sys/time.h>
#include <sys/timeb.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <unistd.h>
#include <zlib.h>
#include <math.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include "wepdecrypt.h"
#include "wepfilter.h"
#include "log.h"
#include "config.h"
#include "modes.h"
#include "messages.h"
#include "misc.h"
#include "localkeygen.h"
#include "wepserver.h"
#include "wepclient.h"


wlan_packet_list* current_packet;

// local list with wlan packets
static wlan_packet_list* list_packet_to_crack;

// filepointer to read wordlist from
static FILE * fp;

// for time measuring
struct timeval t_val_start, t_val_end;
struct timezone t_zone;

// statistics
static long word_count = 1;
static double duration = 0;

// default mode (all modes sequential)
unsigned char use_modes = 0x01;

// to check bssid
char* BSSID=NULL;
wlan_packet_list* bssids_list=NULL;
int is_bssid_check_set = 0;

// server_mode
int	server_mode = 0;

//Key Used
unsigned char key[20];

void clean_up();

//
// get a line from stream
//
int get_line (char * line, FILE * stream, int lenght)
{
	int i=0;
	
	while (i < lenght && (line[i] = fgetc(stream)) != '\n') i++;
	line[i] = '\0';
	
	if (i == lenght) return 0;
	else return 1;
}

//
// load wlan packets from infile
//
void load_packets(char *infile, int network) {

	int network_count = 0, num_networks = 0;
	wlan_packet_list* aux;
	wlan_packet_list* aux_2;
	wlan_packet_list* aux3;
	char bssid_aux[18],bssid_aux2[13],bssid_aux3[18],bssid_aux4[13];

	// load networks from file
	list_packet_to_crack = get_packets(infile, server_mode);

	// check if at least one network is found
	if (list_packet_to_crack == NULL) {
		fprintf(stdout, "\n0 networks loaded...\n");
		exit(1);
	}

	current_packet = list_packet_to_crack;

	// make another list with provided bssid
	if (is_bssid_check_set){
		for (aux=current_packet; aux!=NULL;aux=aux->next){
			sprintf(bssid_aux,"%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",aux->frame.bssid[0],aux->frame.bssid[1],aux->frame.bssid[2],aux->frame.bssid[3],aux->frame.bssid[4],aux->frame.bssid[5]);
			sprintf(bssid_aux2,"%.2X%.2X%.2X%.2X%.2X%.2X",aux->frame.bssid[0],aux->frame.bssid[1],aux->frame.bssid[2],aux->frame.bssid[3],aux->frame.bssid[4],aux->frame.bssid[5]);
			sprintf(bssid_aux3,"%.2x:%.2x:%.2x:%.2x:%.2x:%.2x",aux->frame.bssid[0],aux->frame.bssid[1],aux->frame.bssid[2],aux->frame.bssid[3],aux->frame.bssid[4],aux->frame.bssid[5]);
			sprintf(bssid_aux4,"%.2x%.2x%.2x%.2x%.2x%.2x",aux->frame.bssid[0],aux->frame.bssid[1],aux->frame.bssid[2],aux->frame.bssid[3],aux->frame.bssid[4],aux->frame.bssid[5]);
			if ((strncmp(bssid_aux,BSSID,17) == 0) || (strncmp(bssid_aux2,BSSID,12) == 0) || (strncmp(bssid_aux3,BSSID,17) == 0) || (strncmp(bssid_aux4,BSSID,12) == 0)){
				aux_2 = malloc(sizeof(wlan_packet_list));
				memcpy(&aux_2->frame.frameControl, aux->frame.frameControl, 2);
				memcpy(&aux_2->frame.duration, aux->frame.duration, 2);
				memcpy(&aux_2->frame.srcAddress, aux->frame.srcAddress, 6);
				memcpy(&aux_2->frame.dstAddress, aux->frame.dstAddress, 6);
				memcpy(&aux_2->frame.bssid, aux->frame.bssid, 6);
				if(aux->frame.address4 > 0) {
					memcpy(&aux_2->frame.address4, aux->frame.address4, 6);
				}
				memcpy(&aux_2->frame.sequenceControl, aux->frame.sequenceControl, 2);
				memcpy(&aux_2->frame.iv, &aux->frame.iv, 3);
				aux_2->frame.key=aux->frame.key;
				memcpy(&aux_2->frame.payload, aux->frame.payload, (aux->framesize)- (aux->frame.limits_payload));
				if (bssids_list == NULL){
					aux3 = malloc(sizeof(wlan_packet_list));
					aux3->next = NULL;
					bssids_list = aux3;
				}
				aux_2->framesize = aux->framesize;
				aux_2->next = bssids_list;
				bssids_list = aux_2;
			}
		}
		if (bssids_list != NULL){
		// we must free the old list
			delete_list(list_packet_to_crack);
			list_packet_to_crack = bssids_list;
			current_packet = list_packet_to_crack;
		}
		else printf("\n\nProvided BSSID not found. Cracking all networks");
	}
	
	// list all available networks
    printf("\n\nFounded BSSID:");
    while (current_packet->next != NULL) {
		network_count++;
		printf("\n%d)  ", network_count);
		print_hex_array(stdout, current_packet->frame.bssid, 6);
		printf("/ Key %d", current_packet->frame.key);
		current_packet = current_packet->next;
	}

	if (network >= network_count)
		network = 0;

	if (network){
		aux = current_packet = list_packet_to_crack;
		num_networks = network;
		while (num_networks != network_count){
			list_packet_to_crack = current_packet = current_packet->next;
			free(aux);
			aux = current_packet;
			num_networks++;
		}
		network_count = network;
	}		

	printf("\n%d network%s loaded...\n", network_count, network_count>1?"s":"");

}

//

// test if all packets are cracked
//
int all_packets_cracked() {

	int all = 1;

	// set current packet to first packet
	current_packet = list_packet_to_crack;
	// test each packet
	while (current_packet->next != NULL) {
		if (current_packet->cracked != 1)
			all--;
		current_packet = current_packet->next;
	}

	current_packet = list_packet_to_crack;
	return (all<1)?0:1;
}

//
// test key on every packet with requested modes
//
void loop_packets (unsigned char *key, unsigned char * server_host, int server_port, unsigned char * packet_file, int client_mode){
	int KEY_SIZE;

	while(current_packet->next != NULL) {
		if (!current_packet->cracked) {
			// mode wep 64 bit
			if ((use_modes & 0x07) == 0 || (use_modes & 0x07) == 1) {
				//correct size of the key
				if ((use_modes & 0x07) == 0) KEY_SIZE = 5;
				else KEY_SIZE = strlen(key);

				if (mode_wep(key, KEY_SIZE, 5)){
					wlan_key_cracked();
					if (client_mode) server_connection(server_host, server_port, packet_file, NULL, NULL, key, current_packet->frame.bssid, NULL, DECRYPTED_KEYS);
				}
			}
			// mode wep 128 bit
			if ((use_modes & 0x07) == 2 || (use_modes & 0x07) == 1) {
				//correct size of the key
				if ((use_modes & 0x07) == 2) KEY_SIZE = 13;
				else KEY_SIZE = strlen(key);

				if (mode_wep(key, KEY_SIZE, 13)){
					wlan_key_cracked();
					if (client_mode) server_connection(server_host, server_port, packet_file, NULL, NULL, key, current_packet->frame.bssid, NULL, DECRYPTED_KEYS);
				}					
			}
			// mode with keygen 64 bit
			if ((use_modes & 0x07) == 4 || (use_modes & 0x07) == 1 || (use_modes & 0x07) == 3){
				if (mode_keygen(key, strlen(key), 5))
					wlan_key_cracked();
			}
			// mode with keygen 128 bit
			if ((use_modes & 0x07) == 6 || (use_modes & 0x07) == 1 || (use_modes & 0x07) == 3){				
				if (mode_keygen(key, strlen(key), 13))
					wlan_key_cracked();
			}
		}
		current_packet = current_packet->next;
	}
}

//
// signal handler for ctrl+c
//
void sigint() {

	if (!server_mode){
		printf("\nAborting... writing result to '%s'\n", logfile);
		clean_up();
	}
	else{
		server_stop();
		exit(0);
	}
}

void sigchld(int sign){	
	waitpid(-1,NULL,WNOHANG);
}

void sighup(){
	server_stop();
	exit(0);
}

//
// print statistic and update logfile with uncracked networks
//
void clean_up() {

	// get end time
	gettimeofday(&t_val_end, &t_zone);

	// calculate elapsed time
	duration = difftime_us(&t_val_start, &t_val_end);
	printf("\ntime: %f sec\twords: %ld\n\n", duration, word_count);

	// write ucracked packets to logfile
	log_uncracked(list_packet_to_crack, key, use_modes);

	// close word input stream
	fclose(fp);

	delete_list(list_packet_to_crack);

	exit(0);
}

//
// main for wepdecrypt
//
int main(int argc, char * argv[]) {

	FILE*		pf;
	char* 		mode_opt;
	int 		i = 0, server_port=0, number_blocks = 0, keygen_mode = -1;
	int			initialized_start_key=0, initialized_end_key=0, total_blocks, line_len;
	register int 	op;
	char 		*packet_file = NULL, *word_file = "stdin all modes";
	int 		network_arg = 0;
	int 		control_key = 1;
	int			network_count = 0;
	int			client_mode = 0;
	int			get_file = 0;
	int			hexkeyfile = 0;
	unsigned char *start_key = NULL, *end_key = NULL;
	unsigned char skey[13], ekey[13];
	unsigned char *server_data = NULL, *server_host = NULL;
	unsigned char line[50];
#ifdef __CYGWIN__
	char * win_file_name[100], * win_word_file[100];
#endif

	fp = stdin;

	// install signal handler
	signal(SIGINT, sigint);	
	signal(SIGCHLD, sigchld);
	signal(SIGHUP, sighup);

	// if no arguments are given, exit
	if(argc <= 1) {
		show_help();
		return 0;
	}

	// process command line options
	// program will terminate, if invalid options are passed
    while((op = getopt(argc, argv, "n:b:m:f:i:e:c:d:w:l:?vhsg")) != -1) {
    	switch(op) {
		case 'n':
			network_arg = atoi(optarg);
			break;
		case 'b':
			BSSID = optarg;
			is_bssid_check_set = 1;
			break;
        // arg for packet file to read from
		case 'f':
			if (packet_file != NULL){
				fprintf(stdout,"\nUsage error: -f option can't be used twice\n\n");
				show_help();
				return 0;
			}
            packet_file = optarg;

#ifdef __CYGWIN__
			cygwin_conv_to_win32_path(packet_file, win_file_name);
			packet_file = win_file_name;
#endif
			
            break;
		// server mode
#ifndef __CYGWIN__
		case 's':
			server_mode = 1;
			break;
#endif
		// client_mode
		case 'c':
			client_mode = 1;
			word_file = "Client mode";		
			server_data = optarg;
			for (i=0;i<strlen(server_data);i++){
				if (server_data[i] == ':') break; 
			}
			if (i==strlen(server_data) || i==(strlen(server_data) - 1)){
				printf("\nBad client connection data!\n\n");
				show_help();
				return 0;
			}
			//Parse the server data
			server_host=malloc(i+1);
			memcpy(server_host,server_data,(i));
			server_host[i+1] = '\0';			
			server_port=atoi(server_data + (i+1));			
			break;
		// to get the file from server
		case 'g':
			get_file = 1;			
			break;
		// set number blocks
		case 'l':
			number_blocks = atoi(optarg);
			total_blocks = number_blocks;
			if (number_blocks == 0) number_blocks = -1;
			break;
		// arg for modes
        case 'm':
			mode_opt = optarg;
			if (strcmp(mode_opt,"64")== 0){
				if ((strcmp(word_file,"stdin all modes")!=0) && !hexkeyfile){
					fprintf(stdout,"\nUsage error: w option can't be used with 64 or 128 mode!\n\n");
					show_help();
					return 0;
				}
				word_file = "64 Bit Keygen";
				start_key = "00:00:00:00:00";
				end_key = "FF:FF:FF:FF:FF";
				use_modes = 0x00;
			}
			else if (strcmp(mode_opt, "128") == 0){
				if ((strcmp(word_file,"stdin all modes")!=0) && !hexkeyfile){
					fprintf(stdout,"\nUsage error: w option can't be used with 64 or 128 mode!\n\n");
					show_help();
					return 0;
				}
				word_file = "128 Bit Keygen";
				start_key = "00:00:00:00:00:00:00:00:00:00:00:00:00";
				end_key = "FF:FF:FF:FF:FF:FF:FF:FF:FF:FF:FF:FF:FF";
				use_modes = 0x02;
			}
			else if (strcmp(mode_opt, "n64") == 0){
				word_file = "stdin n64";
				use_modes = 0x04;
			}
			else if (strcmp(mode_opt, "n128") == 0){
				word_file = "stdin n128";
				use_modes = 0x06;
			}
			else if (strcmp(mode_opt, "nall") == 0){
				word_file = "stdin n64 & n128";
				use_modes = 0x03;
			}
			break;
		// start key
		case 'i':
			if (use_modes != 0x00 && use_modes != 0x02){
				fprintf(stdout,"\nUsage error: -i option needs to be used after 64 or 128 mode!\n\n");
				show_help();
				return 0;
			}
			if (keygen_mode != -1){
				fprintf(stdout,"\nUsage error: -i option can't be used with -d option!\n\n");
				show_help();
				return 0;
			}
			start_key = optarg;
			initialized_start_key=1;
			// Bad size
			if (strlen(start_key) != 14 && strlen(start_key) != 38){
				fprintf(stdout,"\nKey Error: Start key must be 64 or 128 size\n\n");
				show_help();
				return 0;
			}	
			break;
		// end key
		case 'e':
			if (use_modes != 0x00 && use_modes != 0x02){
				fprintf(stdout,"\nUsage error: -e option needs to be used after 64 or 128 mode!\n\n");
				show_help();
				return 0;
			}
			if (keygen_mode != -1){
				fprintf(stdout,"\nUsage error: -e option can't be used with -d option!\n\n");
				show_help();
				return 0;
			}
			end_key = optarg;
			initialized_end_key=1;
			// Bad Size
			if (strlen(end_key) != 14 && strlen(end_key) != 38){
				fprintf(stdout,"\nKey Error: End key must be 64 or 128 size\n\n");
				show_help();
				return 0;
			}	
			break;
		case 'd':
			if (use_modes != 0x00 && use_modes != 0x02){
				fprintf(stdout,"\nUsage error: -d option needs to be used after 64 or 128 mode!\n\n");
				show_help();
				return 0;
			}
			if (initialized_start_key || initialized_end_key){
				fprintf(stdout,"\nUsage error: -d option can't be used with -i or -e options!\n\n");
				show_help();
				return 0;
			}
				
			if (!strncmp(optarg, "all", 3)) keygen_mode = ALL;
			else if (!strncmp(optarg, "alphanum", 8)) keygen_mode = ALPHANUM;
			else if (!strncmp(optarg, "alpha", 5)) keygen_mode = ALPHA;
			else if (!strncmp(optarg, "numeric", 5)) keygen_mode = NUMERIC;
			else if (!strncmp(optarg, "printable", 9)) keygen_mode = PRINTABLE;
			else if (!strncmp(optarg, "random", 5)) keygen_mode = RANDOM;
			else{
				fprintf(stdout,"\nUsage error: Invalid value for -d option!\n\n");
				show_help();
				return 0;
			}
			break;
		// arg for wordfile to read from
		case 'w':
			word_file = optarg;

#ifdef __CYGWIN__
			cygwin_conv_to_win32_path(word_file, win_word_file);
			word_file = win_word_file;
#endif
		
			fp = fopen(word_file, "r");
			if (!fp) {
				fprintf(stdout,"\nWordfile error: No such file or directory!\n\n");
				return 1;
			}
			// Check if we have a hexkey file. First line must contain HEXKEY_FILE hex key must be in 00:...:FF format
			get_line(line, fp,12);
			if (!strncmp(line,"HEXKEY_FILE", 11)) hexkeyfile = 1;
			else {
				if (use_modes == 0 || use_modes == 2){
					fclose(fp);
					fprintf(stdout,"\nUsage error: w option can't be used with 64 or 128 mode!\n\n");
					show_help();
					return 0;
				}
				else fseek(fp, 0, SEEK_SET);
			}
			break;
		// arg for display help
		case '?':
            show_help();
			return 1;
            break;
		case 'h':
			show_help();
			return 1;
			break;
		case 'v':
			show_version();
			return 1;
			break;
		default:
			show_help();
			return 1;
			break;
		}
	}
	
	if (client_mode && get_file){
		fprintf(stdout,"WEPDECRYPT by Fernando Tarin based on Wepattack - Version %s\n", VERSION);
		fprintf(stdout,"Getting file from: %s:%i (local.dump)\n", server_host, server_port);
		if (!server_connection(server_host,server_port, NULL, NULL, NULL, NULL, NULL, NULL, GET_FILE)){
			return 0;
		}
		fprintf(stdout,"Done...\n");
		return 0;
	}
	
	pf = fopen(packet_file,"r");
	if (!pf) {
		if (!server_mode){
			fprintf(stdout, "Dumpfile error: No such file or directory!\n\n");
			show_help();
		}
		else fprintf(stdout,"Dumpfile error: No such file or directory!\n");
		return 1;
	}
	fclose(pf);


	// No infile specified
	if(packet_file == NULL) {
		if (!server_mode){
			fprintf(stdout,"\nDumpfile error: No dumpfile specified!\n\n");
			show_help();
		}
		else {
			fprintf(stdout,"Dumpfile error: No dumpfile specified for server mode\n");
		}		
		return 0;
	}
	
	// Server & client mode used together
	if (server_mode && client_mode){
		fprintf(stdout, "\nUsage error: server & client can't be used togheter!\n\n");
		show_help();
		return 0;
	}
	
	// Check that get file isn't used without client mode
	if (!client_mode && get_file){
		fprintf(stdout, "\nUsage error: -g option can't be used without client mode!\n\n");
		show_help();
		return 0;
	}

	// Check that get file is not used with block number blocks
	if (get_file && number_blocks){
		fprintf(stdout, "\nUsage error: -g option can't be used with -l\n\n");
		show_help();
		return 0;
	}
	
	// Check that a hexkeyfile is not used witout appropiated modes
	if (hexkeyfile && (use_modes != 0x00 && use_modes != 0x02)){
		fclose(fp);
		fprintf(stdout, "\nUsage error: wordfile can't be used with 64 or 128 modes without hexkeyfile option\n\n");
		show_help();
		return 0;
	}
	
	// Check that client mode has number blocks && that number blocks isn't used without client mode
	if ((client_mode && !number_blocks) || (!client_mode && number_blocks)){
		fprintf(stdout, "Usage error: client mode needs -l\n\n");
		show_help();
		return 0;
	}
	
	// Start server
	if (server_mode){
		if (use_modes != 0x00 && use_modes != 0x02){
			fprintf(stdout, "Usage error: No cracking or invalid mode specified\n");			
			exit(0);
		}
		list_packet_to_crack = get_packets(packet_file, server_mode);
		current_packet = list_packet_to_crack;
		if (list_packet_to_crack == NULL){
			fprintf(stdout, "0 networks loaded...\n");
			exit(1);
		}
		while (current_packet->next != NULL) {
			network_count++;
			current_packet = current_packet->next;
		}		
		if (use_modes == 0x00){
			if (start_key != NULL){
				if (!parse_key(start_key, key, 64)){
					fprintf(stdout,"\nKey error: Bad key for server mode!\n\n");
					exit(0);
				}
				else
					server_init(packet_file, network_count, 64, key);
			}
			else
				server_init(packet_file, network_count, 64, NULL);
		}
		else {
			if (start_key != NULL){
				if (!parse_key(start_key, key, 128)){
					fprintf(stdout,"\nKey error: Bad key for server mode!\n\n");
					exit(0);
				}
				else
					server_init(packet_file, network_count, 128, key);
			}
			else
				server_init(packet_file, network_count, 128, NULL);
		}
		server_run();
		server_stop();
		exit(0);
	}
	
	// Check provided keys
	if (((use_modes & 0x07) == 0) && !hexkeyfile)
		if (!key_cmp(start_key, end_key, 64)){
			fprintf(stdout,"\nKey error: Start key greater than end key or bad key!\n\n");
			show_help();
			return 0;
		}

	if (((use_modes & 0x07) == 2) && !hexkeyfile)
		if (!key_cmp(start_key, end_key, 128)){
			fprintf(stdout,"\nKey error: Start key greater than end key or bad key!\n\n");
			show_help();
			return 0;
		}

	// load ieee802.11 encrypted packets
	load_packets(packet_file, network_arg);

	// write header to logfile
	open_log(word_file, packet_file);

	// set current packet to crack to first packet in list
	current_packet = list_packet_to_crack;

	// get start time
	gettimeofday(&t_val_start, &t_zone);

	if (((use_modes & 0x07) == 0) && !hexkeyfile){
		if (keygen_mode == -1){
			parse_key(start_key, skey, 64);
			parse_key(end_key, ekey, 64);
			initialize_generator(64, skey, ekey, UDEF);
		}
		else{
			initialize_generator(64, NULL, NULL, keygen_mode);
		}
	}
	else if (((use_modes & 0x07) == 2) && !hexkeyfile){
		if (keygen_mode == -1){
			parse_key(start_key,skey,128);
			parse_key(end_key,ekey,128);
			initialize_generator(128, skey, ekey, UDEF);
		}
		else{
			initialize_generator(128, NULL, NULL, keygen_mode);
		}
	}	

	if (!client_mode)fprintf(stdout, "\nAccepting wordlist data...\n\n");	

	if (client_mode){
		start_key = malloc(sizeof(unsigned char) * 13);
		end_key = malloc(sizeof(unsigned char) * 13);
		do{
			fprintf(stdout, "\nGetting Keys from %s:%i\n", server_host, server_port);

			if (!server_connection(server_host, server_port, packet_file, start_key, end_key, NULL, NULL, &use_modes, GET_KEYS))
				clean_up();
			
			control_key = 1;

			if ((use_modes & 0x07) == 0){
				fprintf(stdout, "Start_key: %.2X:%.2X:%.2X:%.2X:%.2X\n", start_key[0], start_key[1], start_key[2], start_key[3], start_key[4]);
				fprintf(stdout, "End_key:  %.2X:%.2X:%.2X:%.2X:%.2X\n\n", end_key[0], end_key[1], end_key[2], end_key[3], end_key[4]);
				initialize_generator(64, start_key, end_key, UDEF);
			}
			else if ((use_modes & 0x07) == 2){
				fprintf(stdout, "Start_key: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", start_key[0], start_key[1], start_key[2], start_key[3], start_key[4]\
					,start_key[5], start_key[6], start_key[7], start_key[8], start_key[9], start_key[10], start_key[11], start_key[12]);
				fprintf(stdout, "End_key:  %.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n\n", end_key[0], end_key[1], end_key[2], end_key[3], end_key[4]\
					,end_key[5], end_key[6], end_key[7], end_key[8], end_key[9], end_key[10], end_key[11], end_key[12]);
				initialize_generator(128, start_key, end_key, UDEF);
			}

			while (control_key && !all_packets_cracked()) {
				control_key = generate_key(key);
				
				// print out each 100'000 key
#ifndef __CYGWIN__
				if ((word_count % 100000) == 0){
#else
				if ((word_count % 10000) == 0){
#endif
					if (use_modes == 0)
						printf("key no. %ld: %.2X:%.2X:%.2X:%.2X:%.2X\n", word_count, key[0], key[1], key[2],key[3], key[4]);
					else if (use_modes == 2)
						printf("key no. %ld: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", word_count, key[0], key[1], key[2],key[3], key[4]\
							,key[5], key[6], key[7],key[8], key[9], key[10], key[11], key[12]);				
				}
				word_count++;

				// main loop to process key in modes on every packet
				loop_packets(key, server_host, server_port, packet_file, client_mode);
			}
			if (number_blocks != -1) number_blocks--;
			
			if (!server_connection(server_host, server_port, packet_file, NULL, NULL, NULL, NULL, &use_modes, DECRYPTED_BLOCK)){
					clean_up();
			}

		}while(number_blocks != 0 && !all_packets_cracked());

	clean_up();
	}



	// do cracking until all packets are cracked or no more words left
	while (!all_packets_cracked() && !feof(fp) && control_key) {

		if ( ((use_modes & 0x07) == 0 || (use_modes & 0x07) == 2) && !hexkeyfile ) control_key = generate_key(key);

		else{
			if (hexkeyfile){
				get_line(line, fp, 40);
				line_len = strlen(line);
				if (line_len == 14 && use_modes == 0){
					if (!parse_key(line, key, 64)) 
						continue;
				}
				else if (line_len == 38 && use_modes == 2){
					if (!parse_key(line, key, 128))
						continue;
				}
				else
					continue;
			}
			else
				get_line(key, fp, 14);
		}

		// print out each 10'000 key
		if ((word_count % 10000) == 0){
			if (use_modes == 0)
				printf("key no. %ld: %.2X:%.2X:%.2X:%.2X:%.2X\n", word_count, key[0], key[1], key[2],key[3], key[4]);
			else if (use_modes == 2)
				printf("key no. %ld: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", word_count, key[0], key[1], key[2],key[3], key[4]\
					,key[5], key[6], key[7],key[8], key[9], key[10], key[11], key[12]);
			else
				printf("key no. %ld: %s\n", word_count, key);
		}
		word_count++;

		// main loop to process key in modes on every packet
		loop_packets(key, server_host, server_port, packet_file, client_mode);
	}

	clean_up();
	
	return 0;
}
