# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).



## v0.9.8 - 2024-02-01


### 🔥 Breaking Changes
- Service.Stop now uses SIGTERM instead of SIGKILL by default by @jedevc in https://github.com/dagger/dagger/pull/6354

### Added
- Add option to skip healthcheck on exposed ports by @KGB33 in https://github.com/dagger/dagger/pull/6214
- New kill option for Service.Stop by @jedevc in https://github.com/dagger/dagger/pull/6354

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.7 - 2024-01-18


### Added
- New File.name field by @jedevc in https://github.com/dagger/dagger/pull/6431

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.6 - 2024-01-11


### 🔥 Breaking Changes
- Argument to `withDefaultArgs` is now required by @helderco in https://github.com/dagger/dagger/pull/6281

### Fixed
- Fix shim panic when exec-ing an unknown command by @Juneezee in https://github.com/dagger/dagger/pull/6356
- Fix potential panic when exporting cache by @jedevc in https://github.com/dagger/dagger/pull/6378
- Fix concurrent map access in api server by @jedevc in https://github.com/dagger/dagger/pull/6388

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.5 - 2023-12-21


### Added
- New `withoutEntryoint` and `withoutDefaultArgs` fields by @helderco in https://github.com/dagger/dagger/pull/6278

### Fixed
- Clear `defaultArgs` on `withEntrypoint` by default by @helderco in https://github.com/dagger/dagger/pull/6280

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.4 - 2023-12-08


### Added
- New secret scrubbing implementation for more responsive logs by @jedevc in https://github.com/dagger/dagger/pull/6034
- Improved logging during engine startup by @jedevc in https://github.com/dagger/dagger/pull/6075

### Fixed
- Fix `WithMountedDirectory` invalidating cache by @jedevc in https://github.com/dagger/dagger/pull/6211

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.3 - 2023-11-03

### Fixed

- Fixes + performance improvements to experimental features

### What to do next?

- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.2 - 2023-10-30


### Added
- experimental Nvidia GPU support by @matiasinsaurralde in https://github.com/dagger/dagger/pull/5605

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.1 - 2023-10-26


### Added
- Implement new commit resolver for GitRef by @jedevc in https://github.com/dagger/dagger/pull/5910
- Directory supports Glob method by @TomChv in https://github.com/dagger/dagger/pull/5824

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.9.0 - 2023-10-20

### 🔥 Breaking Changes

- engine: new services API with container <=> host networking, explicit start/stop by @vito in https://github.com/dagger/dagger/pull/5557
- implement new conventions for IDable objects by @vito in https://github.com/dagger/dagger/pull/5881

### Added

- engine: support multiple cache configs for upstream remote cache by @sipsma in https://github.com/dagger/dagger/pull/5730

### Changed

- engine: reduce connection retry noise by @sipsma in https://github.com/dagger/dagger/pull/5918

### Fixed

- engine: fix missing descriptor handlers for lazy blobs error w/ cloud cache by @sipsma in https://github.com/dagger/dagger/pull/5885

### What to do next?

- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.8 - 2023-10-11

### Added
- core: use BuildKit's own readiness implementation instead of our custom logic by @jedevc in https://github.com/dagger/dagger/pull/5808
- core: add Engine logs for failed queries in debug mode by @jedevc in https://github.com/dagger/dagger/pull/5827

### Fixed
- cli: restart manually stopped engine containers by @jedevc in https://github.com/dagger/dagger/pull/5811
- cli: fix process hang when running certain command with `dagger run` by @wingyplus in https://github.com/dagger/dagger/pull/5712

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.7 - 2023-09-18

### Added
- core: remove syncedCacheMount check for cache manager by @marcosnils in https://github.com/dagger/dagger/pull/5797

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.6 - 2023-09-18

### Added
- core: record seen cache volumes at resolver level by @marcosnils in https://github.com/dagger/dagger/pull/5786

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.5 - 2023-09-13

### Added
- cli: add `DAGGER_SESSION_TOKEN` env var support in `listen` command by @marcosnils in https://github.com/dagger/dagger/pull/5704
- core: Extends mounted secret API to support mode and optional arguments by @TomChv in https://github.com/dagger/dagger/pull/5707
- engine: add `DAGGER_CLOUD_TOKEN` env var support by @marcosnils in https://github.com/dagger/dagger/pull/5773

### Fixed
- engine: fix panic if `_EXPERIMENTAL_DAGGER_SERVICES_DNS` is disabled by @vbehar in https://github.com/dagger/dagger/pull/5760
- services: refactor to per-client instances that stop on client close by @vito in https://github.com/dagger/dagger/pull/5764
- cli: fix interactive TUI nil panic by @vito in https://github.com/dagger/dagger/pull/5681

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.4 - 2023-08-17

### Fixed
- Default container tar export permissions to 0600 by @sipsma in https://github.com/dagger/dagger/pull/5649

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.3 - 2023-08-16

### Added
- Include details during Dagger Engine loading by @TomChv in https://github.com/dagger/dagger/pull/5436
- Show host target on directory or file export by @TomChv in https://github.com/dagger/dagger/pull/5632

### Changed
- Hide merge vertexes from output by @sipsma in https://github.com/dagger/dagger/pull/5630

### Fixed
- Fix Engine connection hang when UTF8 characters present in labels by @vito in https://github.com/dagger/dagger/pull/5628
- Export files with same permissions as source by @sipsma in https://github.com/dagger/dagger/pull/5629

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.2 - 2023-08-10

### Added
- remote cache: improve http error checking by @aluzzardi in https://github.com/dagger/dagger/pull/5506

### Fixed
- engine: fix combined cache manager to query local cache too by @sipsma in https://github.com/dagger/dagger/pull/5585
- telemetry: fix labels not being included by @vito in https://github.com/dagger/dagger/pull/5602

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.1 - 2023-08-04

### Fixed
- cli: fix `dagger run` not showing command progress by @vito in https://github.com/dagger/dagger/pull/5564
- core: fix setting image config during multiplatform export+publish by @sipsma in https://github.com/dagger/dagger/pull/5574
- core: fix exports of files larger than default grpc max message size by @sipsma in https://github.com/dagger/dagger/pull/5570
- engine: report correct engine version by stamping engine image too by @sipsma in https://github.com/dagger/dagger/pull/5578
- core: handle v prefix in version compatibility check by @sipsma in https://github.com/dagger/dagger/pull/5578

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.8.0 - 2023-08-03


### 🔥 Breaking Changes
- engine: remove API deprecations by @helderco in https://github.com/dagger/dagger/pull/5512
- engine: Rename `id` argument in `Container.withRootfs` by @helderco in https://github.com/dagger/dagger/pull/5513

### Added
- engine: implement `Host.setSecretFile` to securely set binary files as secrets by @grouville in https://github.com/dagger/dagger/pull/5500

### Fixed
- engine: Bump Alpine version to fix service DNS resolution by @marcosnils in https://github.com/dagger/dagger/pull/5470

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.6.4 - 2023-07-19

### Added
- cli: show total duration at the end of a run by @vito in https://github.com/dagger/dagger/pull/5476
- engine: add `Directory.Sync` by @helderco in https://github.com/dagger/dagger/pull/5414
- engine: add `File.Sync` by @helderco in https://github.com/dagger/dagger/pull/5416
- engine: add `Container.WithFocus` & `Container.WithoutFocus` by @vito in https://github.com/dagger/dagger/pull/5364
- engine: add `include` & `exclude` to host dir copy name by @sipsma in https://github.com/dagger/dagger/pull/5469

### Deprecated
- engine: deprecate `exitCode` by @helderco in https://github.com/dagger/dagger/pull/5481

### Fixed
- engine: prevent session id from busting caches everywhere by @vito in https://github.com/dagger/dagger/pull/5474
- engine: optimize `WithDirectory` & `WithFile` via MergeOp by @sipsma in https://github.com/dagger/dagger/pull/5400
- engine: remove unimplemented git fields by @helderco in https://github.com/dagger/dagger/pull/5410
- engine: support optionally setting explicit OCI mediatypes by @sipsma in https://github.com/dagger/dagger/pull/5467

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)



## v0.6.3 - 2023-07-04

### Added
* cache: Set default Cloud Cache URL by @marcosnils in https://github.com/dagger/dagger/pull/5343
* engine: Add Cloud Cache token env var by @marcosnils in https://github.com/dagger/dagger/pull/5356
* core: Improve image publish/export format compatibility by @sipsma in https://github.com/dagger/dagger/pull/5365
* core: Send Progrock updates to Cloud by @vito in https://github.com/dagger/dagger/pull/5297

### Fixed
* core: Use include filter in host.file by @sipsma in https://github.com/dagger/dagger/pull/5345
* cli: Fix incorrect subcommand being called by @sipsma in https://github.com/dagger/dagger/pull/5344
* engine: Remove old Cache config env from autoprovision by @sipsma in https://github.com/dagger/dagger/pull/5355

### What to do next?
- Read the [documentation](https://docs.dagger.io)
- Join our [Discord server](https://discord.gg/dagger-io)
- Follow us on [Twitter](https://twitter.com/dagger_io)
