/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.OutputType;
import org.asamk.signal.commands.JsonRpcRegistrationCommand;
import org.asamk.signal.commands.RegistrationCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.output.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyCommand
implements RegistrationCommand,
JsonRpcRegistrationCommand<VerifyParams> {
    private static final Logger logger = LoggerFactory.getLogger(VerifyCommand.class);

    @Override
    public String getName() {
        return "verify";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Verify the number using the code received via SMS or voice.");
        subparser.addArgument(new String[]{"verification-code"}).help("The verification code you received via sms or voice call.");
        subparser.addArgument(new String[]{"-p", "--pin"}).help("The registration lock PIN, that was set by the user (Optional)");
    }

    @Override
    public void handleCommand(Namespace ns, RegistrationManager m) throws CommandException {
        String verificationCode = ns.getString("verification-code");
        String pin = ns.getString("pin");
        this.verify(m, verificationCode, pin);
    }

    @Override
    public TypeReference<VerifyParams> getRequestType() {
        return new TypeReference<VerifyParams>(this){};
    }

    @Override
    public List<OutputType> getSupportedOutputTypes() {
        return List.of(OutputType.PLAIN_TEXT, OutputType.JSON);
    }

    @Override
    public void handleCommand(VerifyParams request, RegistrationManager m, JsonWriter jsonWriter) throws CommandException {
        this.verify(m, request.verificationCode(), request.pin());
    }

    private void verify(RegistrationManager m, String verificationCode, String pin) throws UserErrorException, IOErrorException {
        try {
            m.verifyAccount(verificationCode, pin);
        }
        catch (PinLockedException e) {
            throw new UserErrorException("Verification failed! This number is locked with a pin. Hours remaining until reset: " + e.getTimeRemaining() / 1000L / 60L / 60L + "\nUse '--pin PIN_CODE' to specify the registration lock PIN");
        }
        catch (IncorrectPinException e) {
            throw new UserErrorException("Verification failed! Invalid pin, tries remaining: " + e.getTriesRemaining());
        }
        catch (IOException e) {
            throw new IOErrorException("Verify error: " + e.getMessage(), e);
        }
    }

    public record VerifyParams(String verificationCode, String pin) {
    }
}

