/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.contacts.crypto;

import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import org.signal.core.util.Base64;

public class SigningCertificate {
    private final CertPath path;

    public SigningCertificate(String certificateChain, KeyStore trustStore) throws CertificateException, CertPathValidatorException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificatesCollection = certificateFactory.generateCertificates(new ByteArrayInputStream(certificateChain.getBytes()));
            LinkedList<? extends Certificate> certificates = new LinkedList<Certificate>(certificatesCollection);
            PKIXParameters pkixParameters = new PKIXParameters(trustStore);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            if (certificates.isEmpty()) {
                throw new CertificateException("No certificates available! Badly-formatted cert chain?");
            }
            this.path = certificateFactory.generateCertPath(certificates);
            pkixParameters.setRevocationEnabled(false);
            validator.validate(this.path, pkixParameters);
            this.verifyDistinguishedName(this.path);
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void verifySignature(String body, String encodedSignature) throws SignatureException {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(this.path.getCertificates().get(0));
            signature.update(body.getBytes());
            if (!signature.verify(Base64.decode((byte[])encodedSignature.getBytes()))) {
                throw new SignatureException("Signature verification failed.");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void verifyDistinguishedName(CertPath path) throws CertificateException {
        X509Certificate leaf = (X509Certificate)path.getCertificates().get(0);
        String distinguishedName = leaf.getSubjectX500Principal().getName();
        if (!"CN=Intel SGX Attestation Report Signing,O=Intel Corporation,L=Santa Clara,ST=CA,C=US".equals(distinguishedName)) {
            throw new CertificateException("Bad DN: " + distinguishedName);
        }
    }
}

