/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.signal.libsignal.protocol.logging.Log;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.messages.EnvelopeResponse;
import org.whispersystems.signalservice.api.websocket.WebSocketConnectionState;
import org.whispersystems.signalservice.api.websocket.WebSocketFactory;
import org.whispersystems.signalservice.api.websocket.WebSocketUnavailableException;
import org.whispersystems.signalservice.internal.push.Envelope;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebSocketResponseMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

public final class SignalWebSocket {
    private static final String TAG = SignalWebSocket.class.getSimpleName();
    private static final String SERVER_DELIVERED_TIMESTAMP_HEADER = "X-Signal-Timestamp";
    private final WebSocketFactory webSocketFactory;
    private WebSocketConnection webSocket;
    private final BehaviorSubject<WebSocketConnectionState> webSocketState;
    private CompositeDisposable webSocketStateDisposable;
    private WebSocketConnection unidentifiedWebSocket;
    private final BehaviorSubject<WebSocketConnectionState> unidentifiedWebSocketState;
    private CompositeDisposable unidentifiedWebSocketStateDisposable;
    private boolean canConnect;

    public SignalWebSocket(WebSocketFactory webSocketFactory) {
        this.webSocketFactory = webSocketFactory;
        this.webSocketState = BehaviorSubject.createDefault((Object)((Object)WebSocketConnectionState.DISCONNECTED));
        this.unidentifiedWebSocketState = BehaviorSubject.createDefault((Object)((Object)WebSocketConnectionState.DISCONNECTED));
        this.webSocketStateDisposable = new CompositeDisposable();
        this.unidentifiedWebSocketStateDisposable = new CompositeDisposable();
    }

    public Observable<WebSocketConnectionState> getWebSocketState() {
        return this.webSocketState;
    }

    public Observable<WebSocketConnectionState> getUnidentifiedWebSocketState() {
        return this.unidentifiedWebSocketState;
    }

    public synchronized void connect() {
        this.canConnect = true;
        try {
            this.getWebSocket();
            this.getUnidentifiedWebSocket();
        }
        catch (WebSocketUnavailableException e) {
            throw new AssertionError((Object)e);
        }
    }

    public synchronized void disconnect() {
        this.canConnect = false;
        this.disconnectIdentified();
        this.disconnectUnidentified();
    }

    public synchronized void forceNewWebSockets() {
        Log.i((String)TAG, (String)("Forcing new WebSockets  identified: " + (this.webSocket != null ? this.webSocket.getName() : "[null]") + " unidentified: " + (this.unidentifiedWebSocket != null ? this.unidentifiedWebSocket.getName() : "[null]") + " canConnect: " + this.canConnect));
        this.disconnectIdentified();
        this.disconnectUnidentified();
    }

    private void disconnectIdentified() {
        if (this.webSocket != null) {
            this.webSocketStateDisposable.dispose();
            this.webSocket.disconnect();
            this.webSocket = null;
            if (!((WebSocketConnectionState)((Object)this.webSocketState.getValue())).isFailure()) {
                this.webSocketState.onNext((Object)WebSocketConnectionState.DISCONNECTED);
            }
        }
    }

    private void disconnectUnidentified() {
        if (this.unidentifiedWebSocket != null) {
            this.unidentifiedWebSocketStateDisposable.dispose();
            this.unidentifiedWebSocket.disconnect();
            this.unidentifiedWebSocket = null;
            if (!((WebSocketConnectionState)((Object)this.unidentifiedWebSocketState.getValue())).isFailure()) {
                this.unidentifiedWebSocketState.onNext((Object)WebSocketConnectionState.DISCONNECTED);
            }
        }
    }

    private synchronized WebSocketConnection getWebSocket() throws WebSocketUnavailableException {
        if (!this.canConnect) {
            throw new WebSocketUnavailableException();
        }
        if (this.webSocket == null || this.webSocket.isDead()) {
            this.webSocketStateDisposable.dispose();
            this.webSocket = this.webSocketFactory.createWebSocket();
            this.webSocketStateDisposable = new CompositeDisposable();
            Disposable state = this.webSocket.connect().subscribeOn(Schedulers.computation()).observeOn(Schedulers.computation()).subscribe(arg_0 -> this.webSocketState.onNext(arg_0));
            this.webSocketStateDisposable.add(state);
        }
        return this.webSocket;
    }

    private synchronized WebSocketConnection getUnidentifiedWebSocket() throws WebSocketUnavailableException {
        if (!this.canConnect) {
            throw new WebSocketUnavailableException();
        }
        if (this.unidentifiedWebSocket == null || this.unidentifiedWebSocket.isDead()) {
            this.unidentifiedWebSocketStateDisposable.dispose();
            this.unidentifiedWebSocket = this.webSocketFactory.createUnidentifiedWebSocket();
            this.unidentifiedWebSocketStateDisposable = new CompositeDisposable();
            Disposable state = this.unidentifiedWebSocket.connect().subscribeOn(Schedulers.computation()).observeOn(Schedulers.computation()).subscribe(arg_0 -> this.unidentifiedWebSocketState.onNext(arg_0));
            this.unidentifiedWebSocketStateDisposable.add(state);
        }
        return this.unidentifiedWebSocket;
    }

    public synchronized void sendKeepAlive() throws IOException {
        if (this.canConnect) {
            try {
                this.getWebSocket().sendKeepAlive();
                this.getUnidentifiedWebSocket().sendKeepAlive();
            }
            catch (WebSocketUnavailableException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public Single<WebsocketResponse> request(WebSocketRequestMessage requestMessage) {
        try {
            return this.getWebSocket().sendRequest(requestMessage);
        }
        catch (IOException e) {
            return Single.error((Throwable)e);
        }
    }

    public Single<WebsocketResponse> request(WebSocketRequestMessage requestMessage, @Nullable SealedSenderAccess sealedSenderAccess) {
        if (sealedSenderAccess != null) {
            ArrayList<String> headers = new ArrayList<String>(requestMessage.headers);
            headers.add(sealedSenderAccess.getHeader());
            WebSocketRequestMessage message = requestMessage.newBuilder().headers(headers).build();
            try {
                return this.getUnidentifiedWebSocket().sendRequest(message).flatMap(r -> {
                    if (r.getStatus() == 401) {
                        return this.request(requestMessage, sealedSenderAccess.switchToFallback());
                    }
                    return Single.just((Object)r);
                });
            }
            catch (IOException e) {
                return Single.error((Throwable)e);
            }
        }
        return this.request(requestMessage);
    }

    public boolean readMessageBatch(long timeout, int batchSize, MessageReceivedCallback callback) throws TimeoutException, WebSocketUnavailableException, IOException {
        ArrayList<EnvelopeResponse> responses = new ArrayList<EnvelopeResponse>();
        boolean hitEndOfQueue = false;
        Optional<EnvelopeResponse> firstEnvelope = this.waitForSingleMessage(timeout);
        if (firstEnvelope.isPresent()) {
            responses.add(firstEnvelope.get());
        } else {
            hitEndOfQueue = true;
        }
        if (!hitEndOfQueue) {
            Optional<WebSocketRequestMessage> request;
            for (int i = 1; i < batchSize && (request = this.getWebSocket().readRequestIfAvailable()).isPresent(); ++i) {
                if (SignalWebSocket.isSignalServiceEnvelope(request.get())) {
                    responses.add(SignalWebSocket.requestToEnvelopeResponse(request.get()));
                    continue;
                }
                if (!SignalWebSocket.isSocketEmptyRequest(request.get())) continue;
                hitEndOfQueue = true;
                break;
            }
        }
        if (responses.size() > 0) {
            callback.onMessageBatch(responses);
        }
        return !hitEndOfQueue;
    }

    public void sendAck(EnvelopeResponse response) throws IOException {
        this.getWebSocket().sendResponse(SignalWebSocket.createWebSocketResponse(response.getWebsocketRequest()));
    }

    private Optional<EnvelopeResponse> waitForSingleMessage(long timeout) throws TimeoutException, WebSocketUnavailableException, IOException {
        WebSocketRequestMessage request;
        do {
            if (!SignalWebSocket.isSignalServiceEnvelope(request = this.getWebSocket().readRequest(timeout))) continue;
            return Optional.of(SignalWebSocket.requestToEnvelopeResponse(request));
        } while (!SignalWebSocket.isSocketEmptyRequest(request));
        return Optional.empty();
    }

    private static EnvelopeResponse requestToEnvelopeResponse(WebSocketRequestMessage request) throws IOException {
        Optional<String> timestampHeader = SignalWebSocket.findHeader(request);
        long timestamp = 0L;
        if (timestampHeader.isPresent()) {
            try {
                timestamp = Long.parseLong(timestampHeader.get());
            }
            catch (NumberFormatException e) {
                Log.w((String)TAG, (String)"Failed to parse X-Signal-Timestamp");
            }
        }
        Envelope envelope = (Envelope)((Object)Envelope.ADAPTER.decode(request.body.toByteArray()));
        return new EnvelopeResponse(envelope, timestamp, request);
    }

    private static boolean isSignalServiceEnvelope(WebSocketRequestMessage message) {
        return "PUT".equals(message.verb) && "/api/v1/message".equals(message.path);
    }

    private static boolean isSocketEmptyRequest(WebSocketRequestMessage message) {
        return "PUT".equals(message.verb) && "/api/v1/queue/empty".equals(message.path);
    }

    private static WebSocketResponseMessage createWebSocketResponse(WebSocketRequestMessage request) {
        if (SignalWebSocket.isSignalServiceEnvelope(request)) {
            return new WebSocketResponseMessage.Builder().id(request.id).status(200).message("OK").build();
        }
        return new WebSocketResponseMessage.Builder().id(request.id).status(400).message("Unknown").build();
    }

    private static Optional<String> findHeader(WebSocketRequestMessage message) {
        if (message.headers.isEmpty()) {
            return Optional.empty();
        }
        for (String header : message.headers) {
            String[] split;
            if (!header.startsWith(SERVER_DELIVERED_TIMESTAMP_HEADER) || (split = header.split(":")).length != 2 || !split[0].trim().toLowerCase().equals(SERVER_DELIVERED_TIMESTAMP_HEADER.toLowerCase())) continue;
            return Optional.of(split[1].trim());
        }
        return Optional.empty();
    }

    public static interface MessageReceivedCallback {
        public void onMessageBatch(List<EnvelopeResponse> var1);
    }
}

