/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.state;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECKeyPair;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public class PreKeyRecord
implements NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.PreKeyRecord_Destroy(this.unsafeHandle);
    }

    public PreKeyRecord(int id, ECKeyPair keyPair) {
        try (NativeHandleGuard publicKey = new NativeHandleGuard(keyPair.getPublicKey());
             NativeHandleGuard privateKey = new NativeHandleGuard(keyPair.getPrivateKey());){
            this.unsafeHandle = Native.PreKeyRecord_New(id, publicKey.nativeHandle(), privateKey.nativeHandle());
        }
    }

    public PreKeyRecord(byte[] serialized) throws InvalidMessageException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.PreKeyRecord_Deserialize(serialized));
    }

    public int getId() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            int n = FilterExceptions.filterExceptions(() -> Native.PreKeyRecord_GetId(guard.nativeHandle()));
            return n;
        }
    }

    public ECKeyPair getKeyPair() throws InvalidKeyException {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            ECKeyPair eCKeyPair = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> {
                ECPublicKey publicKey = new ECPublicKey(Native.PreKeyRecord_GetPublicKey(guard.nativeHandle()));
                ECPrivateKey privateKey = new ECPrivateKey(Native.PreKeyRecord_GetPrivateKey(guard.nativeHandle()));
                return new ECKeyPair(publicKey, privateKey);
            });
            return eCKeyPair;
        }
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.PreKeyRecord_GetSerialized(guard.nativeHandle()));
            return byArray;
        }
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }
}

