/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping.serialize;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.util.CheckedConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractListChildSerializer<T>
implements TypeSerializer<T> {
    AbstractListChildSerializer() {
    }

    @Override
    public final @Nullable T deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        TypeToken<?> entryType = this.getElementType(type);
        TypeSerializer<?> entrySerial = value.getOptions().getSerializers().get(entryType);
        if (entrySerial == null) {
            throw new ObjectMappingException("No applicable type serializer for type " + entryType);
        }
        if (value.isList()) {
            List<? extends ConfigurationNode> values = value.getChildrenList();
            T ret = this.createNew(values.size(), entryType);
            for (int i = 0; i < values.size(); ++i) {
                this.deserializeSingle(i, ret, entrySerial.deserialize(entryType, values.get(i)));
            }
            return ret;
        }
        Object unwrappedVal = value.getValue();
        if (unwrappedVal != null) {
            T ret = this.createNew(1, entryType);
            this.deserializeSingle(0, ret, entrySerial.deserialize(entryType, value));
            return ret;
        }
        return this.createNew(0, entryType);
    }

    @Override
    public final void serialize(@NonNull TypeToken<?> type, @Nullable T obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        TypeToken<?> entryType = this.getElementType(type);
        TypeSerializer<?> entrySerial = value.getOptions().getSerializers().get(entryType);
        if (entrySerial == null) {
            throw new ObjectMappingException("No applicable type serializer for type " + entryType);
        }
        value.setValue(ImmutableList.of());
        if (obj != null) {
            this.forEachElement(obj, el -> entrySerial.serialize(entryType, el, value.appendListNode()));
        }
    }

    abstract TypeToken<?> getElementType(TypeToken<?> var1) throws ObjectMappingException;

    abstract T createNew(int var1, TypeToken<?> var2) throws ObjectMappingException;

    abstract void forEachElement(T var1, CheckedConsumer<Object, ObjectMappingException> var2) throws ObjectMappingException;

    abstract void deserializeSingle(int var1, T var2, Object var3) throws ObjectMappingException;
}

