/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintLengthEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.DataFormatException;

public class MinecraftCompressorAndLengthEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final boolean MUST_USE_SAFE_AND_SLOW_COMPRESSION_HANDLING = Boolean.getBoolean("velocity.increased-compression-cap");
    private int threshold;
    private final VelocityCompressor compressor;

    public MinecraftCompressorAndLengthEncoder(int threshold, VelocityCompressor compressor) {
        this.threshold = threshold;
        this.compressor = compressor;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int uncompressed = msg.readableBytes();
        if (uncompressed < this.threshold) {
            ProtocolUtils.writeVarInt(out, uncompressed + 1);
            ProtocolUtils.writeVarInt(out, 0);
            out.writeBytes(msg);
        } else if (MUST_USE_SAFE_AND_SLOW_COMPRESSION_HANDLING) {
            this.handleCompressedSafe(ctx, msg, out);
        } else {
            this.handleCompressedFast(ctx, msg, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompressedFast(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws DataFormatException {
        int uncompressed = msg.readableBytes();
        ProtocolUtils.write21BitVarInt(out, 0);
        ProtocolUtils.writeVarInt(out, uncompressed);
        ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible(ctx.alloc(), this.compressor, msg);
        int startCompressed = out.writerIndex();
        try {
            this.compressor.deflate(compatibleIn, out);
        }
        finally {
            compatibleIn.release();
        }
        int compressedLength = out.writerIndex() - startCompressed;
        if (compressedLength >= 0x200000) {
            throw new DataFormatException("The server sent a very large (over 2MiB compressed) packet. Please restart Velocity with the JVM flag -Dvelocity.increased-compression-cap=true to fix this issue.");
        }
        int writerIndex = out.writerIndex();
        int packetLength = out.readableBytes() - 3;
        out.writerIndex(0);
        ProtocolUtils.write21BitVarInt(out, packetLength);
        out.writerIndex(writerIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompressedSafe(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws DataFormatException {
        int uncompressed = msg.readableBytes();
        ByteBuf tmpBuf = MoreByteBufUtils.preferredBuffer(ctx.alloc(), this.compressor, uncompressed - 1);
        try {
            ProtocolUtils.writeVarInt(tmpBuf, uncompressed);
            ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible(ctx.alloc(), this.compressor, msg);
            try {
                this.compressor.deflate(compatibleIn, tmpBuf);
            }
            finally {
                compatibleIn.release();
            }
            ProtocolUtils.writeVarInt(out, tmpBuf.readableBytes());
            out.writeBytes(tmpBuf);
        }
        finally {
            tmpBuf.release();
        }
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        int uncompressed = msg.readableBytes();
        if (uncompressed < this.threshold) {
            int finalBufferSize = uncompressed + 1;
            finalBufferSize += ProtocolUtils.varIntBytes(finalBufferSize);
            return MinecraftVarintLengthEncoder.IS_JAVA_CIPHER ? ctx.alloc().heapBuffer(finalBufferSize) : ctx.alloc().directBuffer(finalBufferSize);
        }
        int initialBufferSize = uncompressed - 1 + 3 + ProtocolUtils.varIntBytes(uncompressed);
        return MoreByteBufUtils.preferredBuffer(ctx.alloc(), this.compressor, initialBufferSize);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

