/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.registry.DimensionData;
import com.velocitypowered.proxy.connection.registry.DimensionInfo;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DimensionRegistry {
    private final Map<String, DimensionData> registeredDimensions;
    private final ImmutableSet<String> levelNames;

    public DimensionRegistry(ImmutableSet<DimensionData> registeredDimensions, ImmutableSet<String> levelNames) {
        Preconditions.checkNotNull(registeredDimensions, "registeredDimensions cannot be null");
        Preconditions.checkNotNull(levelNames, "levelNames cannot be null");
        Preconditions.checkArgument(registeredDimensions.size() > 0, "registeredDimensions needs to be populated");
        Preconditions.checkArgument(levelNames.size() > 0, "levelNames needs to populated");
        this.registeredDimensions = Maps.uniqueIndex(registeredDimensions, DimensionData::getRegistryIdentifier);
        this.levelNames = levelNames;
    }

    public Map<String, DimensionData> getRegisteredDimensions() {
        return this.registeredDimensions;
    }

    public Set<String> getLevelNames() {
        return this.levelNames;
    }

    public @Nullable DimensionData getDimensionData(String dimensionIdentifier) {
        return this.registeredDimensions.get(dimensionIdentifier);
    }

    public boolean isValidFor(DimensionInfo toValidate) {
        if (toValidate == null) {
            return false;
        }
        return this.registeredDimensions.containsKey(toValidate.getRegistryIdentifier()) && this.levelNames.contains(toValidate.getLevelName());
    }

    public ListBinaryTag encodeRegistry(ProtocolVersion version) {
        ListBinaryTag.Builder<CompoundBinaryTag> listBuilder = ListBinaryTag.builder(BinaryTagTypes.COMPOUND);
        for (DimensionData iter : this.registeredDimensions.values()) {
            listBuilder.add(iter.encodeAsCompoundTag(version));
        }
        return listBuilder.build();
    }

    public static ImmutableSet<DimensionData> fromGameData(ListBinaryTag toParse, ProtocolVersion version) {
        Preconditions.checkNotNull(toParse, "ListTag cannot be null");
        ImmutableSet.Builder mappings = ImmutableSet.builder();
        for (BinaryTag iter : toParse) {
            if (!(iter instanceof CompoundBinaryTag)) continue;
            mappings.add(DimensionData.decodeRegistryEntry((CompoundBinaryTag)iter, version));
        }
        return mappings.build();
    }
}

