/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.scheduler;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.checkerframework.common.value.qual.IntRange;

public interface Scheduler {
    public TaskBuilder buildTask(Object var1, Runnable var2);

    public static interface TaskBuilder {
        public TaskBuilder delay(@IntRange(from=0L) long var1, TimeUnit var3);

        default public TaskBuilder delay(Duration duration) {
            return this.delay(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        public TaskBuilder repeat(@IntRange(from=0L) long var1, TimeUnit var3);

        default public TaskBuilder repeat(Duration duration) {
            return this.repeat(duration.toMillis(), TimeUnit.MILLISECONDS);
        }

        public TaskBuilder clearDelay();

        public TaskBuilder clearRepeat();

        public ScheduledTask schedule();
    }
}

