/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept compat_keyctl syscall
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - Keyring support
 *
 * Timeline:
 *  - Created: 17.I.2018
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifdef CONFIG_COMPAT

#include "../../../../../p_lkrg_main.h"


char p_compat_sys_keyctl_kretprobe_state = 0;

static struct kretprobe p_compat_sys_keyctl_kretprobe = {
    .kp.symbol_name = P_GET_COMPAT_SYSCALL_NAME(keyctl),
    .handler = p_compat_sys_keyctl_ret,
    .entry_handler = p_compat_sys_keyctl_entry,
    .data_size = sizeof(struct p_compat_sys_keyctl_data),
};


int p_compat_sys_keyctl_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   p_ed_enforce_validation();

   p_tasks_write_lock(&p_flags);
   if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
#ifdef P_LKRG_TASK_OFF_DEBUG
      p_debug_off_flag_off(p_tmp, 18);
#endif
      // This process is on the ED list - set temporary 'disable' flag!
      p_set_ed_process_off(p_tmp);
   }
   p_tasks_write_unlock(&p_flags);

   return 0;
}


int p_compat_sys_keyctl_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   p_debug_kprobe_log(
          "capset returned value => %ld comm[%s] Pid:%d parent[%d]",
                       p_regs_get_ret(p_regs),current->comm,current->pid,current->real_parent->pid);

   // Update process
   p_tasks_write_lock(&p_flags);
   if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
      if (!IS_ERR((void *)p_regs_get_ret(p_regs))) {
         // This process is on the ED list - update information!
         p_update_ed_process(p_tmp, current, 0);
      }
#ifdef P_LKRG_TASK_OFF_DEBUG
      p_debug_off_flag_on(p_tmp, 19);
#endif
      p_set_ed_process_on(p_tmp);
   }
   p_tasks_write_unlock(&p_flags);

//   p_ed_enforce_validation();

   return 0;
}


GENERATE_INSTALL_FUNC(compat_sys_keyctl)

#endif
