/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.NDFloatTable;
import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Rotamer {
    private static Rotamer instance = null;
    HashMap tables;
    HashMap names;
    SidechainAngles2 scAngles2;

    public static Rotamer getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new Rotamer();
        return instance;
    }

    public static void freeInstance() {
        instance = null;
    }

    private Rotamer() throws IOException {
        this.loadTablesFromJar();
        this.loadRotamerNames();
        this.scAngles2 = new SidechainAngles2();
    }

    private void loadTablesFromJar() throws IOException {
        this.tables = new HashMap(30);
        this.tables.put("ser", this.loadTable("rota/ser.ndft"));
        this.tables.put("thr", this.loadTable("rota/thr.ndft"));
        this.tables.put("cys", this.loadTable("rota/cys.ndft"));
        this.tables.put("val", this.loadTable("rota/val.ndft"));
        this.tables.put("pro", this.loadTable("rota/pro.ndft"));
        this.tables.put("leu", this.loadTable("rota/leu.ndft"));
        this.tables.put("ile", this.loadTable("rota/ile.ndft"));
        this.tables.put("trp", this.loadTable("rota/trp.ndft"));
        this.tables.put("asp", this.loadTable("rota/asp.ndft"));
        this.tables.put("asn", this.loadTable("rota/asn.ndft"));
        this.tables.put("his", this.loadTable("rota/his.ndft"));
        NDFloatTable nDFloatTable = this.loadTable("rota/phetyr.ndft");
        this.tables.put("phe", nDFloatTable);
        this.tables.put("tyr", nDFloatTable);
        nDFloatTable = this.loadTable("rota/met.ndft");
        this.tables.put("met", nDFloatTable);
        this.tables.put("mse", nDFloatTable);
        this.tables.put("glu", this.loadTable("rota/glu.ndft"));
        this.tables.put("gln", this.loadTable("rota/gln.ndft"));
        this.tables.put("lys", this.loadTable("rota/lys.ndft"));
        this.tables.put("arg", this.loadTable("rota/arg.ndft"));
    }

    private NDFloatTable loadTable(String string) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Missing resource");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        NDFloatTable nDFloatTable = new NDFloatTable(dataInputStream);
        dataInputStream.close();
        return nDFloatTable;
    }

    private void loadRotamerNames() {
        this.names = new HashMap();
        ArrayList<NamedRot> arrayList = new ArrayList<NamedRot>();
        arrayList.add(new NamedRot("p", new int[]{0, 120}));
        arrayList.add(new NamedRot("t", new int[]{120, 240}));
        arrayList.add(new NamedRot("m", new int[]{240, 360}));
        this.names.put("thr", arrayList);
        this.names.put("val", arrayList);
        this.names.put("ser", arrayList);
        this.names.put("cys", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("Cg_endo", new int[]{0, 180}));
        arrayList.add(new NamedRot("Cg_exo", new int[]{180, 360}));
        this.names.put("pro", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("p90", new int[]{0, 120, 0, 180}));
        arrayList.add(new NamedRot("t80", new int[]{120, 240, 0, 180}));
        arrayList.add(new NamedRot("m-85", new int[]{240, 360, 35, 150}));
        arrayList.add(new NamedRot("m-30", new int[]{240, 360, 0, 35}));
        arrayList.add(new NamedRot("m-30", new int[]{240, 360, 150, 180}));
        this.names.put("phe", arrayList);
        this.names.put("tyr", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("p-90", new int[]{0, 120, 180, 360}));
        arrayList.add(new NamedRot("p90", new int[]{0, 120, 0, 180}));
        arrayList.add(new NamedRot("t-105", new int[]{120, 240, 180, 305}));
        arrayList.add(new NamedRot("t90", new int[]{120, 240, 0, 180}));
        arrayList.add(new NamedRot("t90", new int[]{120, 240, 305, 360}));
        arrayList.add(new NamedRot("m-90", new int[]{240, 360, 180, 305}));
        arrayList.add(new NamedRot("m0", new int[]{240, 360, 305, 360}));
        arrayList.add(new NamedRot("m0", new int[]{240, 360, 0, 45}));
        arrayList.add(new NamedRot("m95", new int[]{240, 360, 45, 180}));
        this.names.put("trp", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("p-80", new int[]{0, 120, 180, 360}));
        arrayList.add(new NamedRot("p80", new int[]{0, 120, 0, 180}));
        arrayList.add(new NamedRot("t-160", new int[]{120, 240, 130, 225}));
        arrayList.add(new NamedRot("t-80", new int[]{120, 240, 225, 360}));
        arrayList.add(new NamedRot("t60", new int[]{120, 240, 0, 130}));
        arrayList.add(new NamedRot("m-70", new int[]{240, 360, 225, 360}));
        arrayList.add(new NamedRot("m-70", new int[]{240, 360, 0, 20}));
        arrayList.add(new NamedRot("m170", new int[]{240, 360, 130, 225}));
        arrayList.add(new NamedRot("m80", new int[]{240, 360, 20, 130}));
        this.names.put("his", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("pp", new int[]{0, 120, 0, 120}));
        arrayList.add(new NamedRot("pt?", new int[]{0, 120, 120, 240}));
        arrayList.add(new NamedRot("tp", new int[]{120, 240, 0, 120}));
        arrayList.add(new NamedRot("tt", new int[]{120, 240, 120, 240}));
        arrayList.add(new NamedRot("tm?", new int[]{120, 240, 240, 360}));
        arrayList.add(new NamedRot("mp", new int[]{240, 360, 0, 120}));
        arrayList.add(new NamedRot("mt", new int[]{240, 360, 120, 240}));
        arrayList.add(new NamedRot("mm?", new int[]{240, 360, 240, 360}));
        this.names.put("leu", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("pp", new int[]{0, 120, 0, 120}));
        arrayList.add(new NamedRot("pt", new int[]{0, 120, 120, 240}));
        arrayList.add(new NamedRot("tp", new int[]{120, 240, 0, 120}));
        arrayList.add(new NamedRot("tt", new int[]{120, 240, 120, 240}));
        arrayList.add(new NamedRot("tm?", new int[]{120, 240, 240, 360}));
        arrayList.add(new NamedRot("mp", new int[]{240, 360, 0, 120}));
        arrayList.add(new NamedRot("mt", new int[]{240, 360, 120, 240}));
        arrayList.add(new NamedRot("mm", new int[]{240, 360, 240, 360}));
        this.names.put("ile", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("p-10", new int[]{0, 120, 180, 360}));
        arrayList.add(new NamedRot("p30", new int[]{0, 120, 0, 180}));
        arrayList.add(new NamedRot("t-20", new int[]{120, 240, 180, 360}));
        arrayList.add(new NamedRot("t-20", new int[]{120, 240, 0, 10}));
        arrayList.add(new NamedRot("t30", new int[]{120, 240, 10, 180}));
        arrayList.add(new NamedRot("m-20", new int[]{240, 360, 300, 360}));
        arrayList.add(new NamedRot("m-20", new int[]{240, 360, 0, 40}));
        arrayList.add(new NamedRot("m-80", new int[]{240, 360, 200, 300}));
        arrayList.add(new NamedRot("m120", new int[]{240, 360, 40, 200}));
        this.names.put("asn", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("p-10", new int[]{0, 120, 90, 180}));
        arrayList.add(new NamedRot("p30", new int[]{0, 120, 0, 90}));
        arrayList.add(new NamedRot("t0", new int[]{120, 240, 0, 45}));
        arrayList.add(new NamedRot("t0", new int[]{120, 240, 120, 180}));
        arrayList.add(new NamedRot("t70", new int[]{120, 240, 45, 120}));
        arrayList.add(new NamedRot("m-20", new int[]{240, 360, 0, 180}));
        this.names.put("asp", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("pt20", new int[]{0, 120, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("pm0", new int[]{0, 120, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("pp0?", new int[]{0, 120, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("tp-100", new int[]{120, 240, 0, 120, 150, 300}));
        arrayList.add(new NamedRot("tp60", new int[]{120, 240, 0, 120, 0, 150}));
        arrayList.add(new NamedRot("tp60", new int[]{120, 240, 0, 120, 300, 360}));
        arrayList.add(new NamedRot("tt0", new int[]{120, 240, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("tm0?", new int[]{120, 240, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("mp0", new int[]{240, 360, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("mt-30", new int[]{240, 360, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("mm-40", new int[]{240, 360, 240, 360, 0, 60}));
        arrayList.add(new NamedRot("mm-40", new int[]{240, 360, 240, 360, 210, 360}));
        arrayList.add(new NamedRot("mm100", new int[]{240, 360, 240, 360, 60, 210}));
        this.names.put("gln", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("pp20?", new int[]{0, 120, 0, 120, 0, 180}));
        arrayList.add(new NamedRot("pt-20", new int[]{0, 120, 120, 240, 0, 180}));
        arrayList.add(new NamedRot("pm0", new int[]{0, 120, 240, 360, 0, 180}));
        arrayList.add(new NamedRot("tp10", new int[]{120, 240, 0, 120, 0, 180}));
        arrayList.add(new NamedRot("tt0", new int[]{120, 240, 120, 240, 0, 180}));
        arrayList.add(new NamedRot("tm-20", new int[]{120, 240, 240, 360, 0, 180}));
        arrayList.add(new NamedRot("mp0", new int[]{240, 360, 0, 120, 0, 180}));
        arrayList.add(new NamedRot("mt-10", new int[]{240, 360, 120, 240, 0, 180}));
        arrayList.add(new NamedRot("mm-40", new int[]{240, 360, 240, 360, 0, 180}));
        this.names.put("glu", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("ppp?", new int[]{0, 120, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("ptp", new int[]{0, 120, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("ptt?", new int[]{0, 120, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("ptm", new int[]{0, 120, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("pmm?", new int[]{0, 120, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("tpp", new int[]{120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("tpp", new int[]{120, 240, 0, 120, 330, 360}));
        arrayList.add(new NamedRot("tpt", new int[]{120, 240, 0, 120, 120, 330}));
        arrayList.add(new NamedRot("ttp", new int[]{120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("ttt", new int[]{120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("ttm", new int[]{120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("tmt?", new int[]{120, 240, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("tmm?", new int[]{120, 240, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("mpp?", new int[]{240, 360, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("mpt?", new int[]{240, 360, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("mtp", new int[]{240, 360, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("mtt", new int[]{240, 360, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("mtm", new int[]{240, 360, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("mmt", new int[]{240, 360, 240, 360, 30, 240}));
        arrayList.add(new NamedRot("mmm", new int[]{240, 360, 240, 360, 0, 30}));
        arrayList.add(new NamedRot("mmm", new int[]{240, 360, 240, 360, 240, 360}));
        this.names.put("met", arrayList);
        this.names.put("mse", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("pppp?", new int[]{0, 120, 0, 120, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("pppt?", new int[]{0, 120, 0, 120, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("pppm?", new int[]{0, 120, 0, 120, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("pptp?", new int[]{0, 120, 0, 120, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("pptt?", new int[]{0, 120, 0, 120, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("pptm?", new int[]{0, 120, 0, 120, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("ppmp?", new int[]{0, 120, 0, 120, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("ppmt?", new int[]{0, 120, 0, 120, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("ppmm?", new int[]{0, 120, 0, 120, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("ptpp?", new int[]{0, 120, 120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("ptpt", new int[]{0, 120, 120, 240, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("ptpm?", new int[]{0, 120, 120, 240, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("pttp", new int[]{0, 120, 120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("pttt", new int[]{0, 120, 120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("pttm", new int[]{0, 120, 120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("ptmp?", new int[]{0, 120, 120, 240, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("ptmt", new int[]{0, 120, 120, 240, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("ptmm?", new int[]{0, 120, 120, 240, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("pmpp?", new int[]{0, 120, 240, 360, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("pmpt?", new int[]{0, 120, 240, 360, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("pmpm?", new int[]{0, 120, 240, 360, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("pmtp?", new int[]{0, 120, 240, 360, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("pmtt?", new int[]{0, 120, 240, 360, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("pmtm?", new int[]{0, 120, 240, 360, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("pmmp?", new int[]{0, 120, 240, 360, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("pmmt?", new int[]{0, 120, 240, 360, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("pmmm?", new int[]{0, 120, 240, 360, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("tppp?", new int[]{120, 240, 0, 120, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("tppt?", new int[]{120, 240, 0, 120, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("tppm?", new int[]{120, 240, 0, 120, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("tptp", new int[]{120, 240, 0, 120, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("tptt", new int[]{120, 240, 0, 120, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("tptm", new int[]{120, 240, 0, 120, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("tpmp?", new int[]{120, 240, 0, 120, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("tpmt?", new int[]{120, 240, 0, 120, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("tpmm?", new int[]{120, 240, 0, 120, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("ttpp", new int[]{120, 240, 120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("ttpt", new int[]{120, 240, 120, 240, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("ttpm?", new int[]{120, 240, 120, 240, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("tttp", new int[]{120, 240, 120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("tttt", new int[]{120, 240, 120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("tttm", new int[]{120, 240, 120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("ttmp?", new int[]{120, 240, 120, 240, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("ttmt", new int[]{120, 240, 120, 240, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("ttmm", new int[]{120, 240, 120, 240, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("tmpp?", new int[]{120, 240, 240, 360, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("tmpt?", new int[]{120, 240, 240, 360, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("tmpm?", new int[]{120, 240, 240, 360, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("tmtp?", new int[]{120, 240, 240, 360, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("tmtt?", new int[]{120, 240, 240, 360, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("tmtm?", new int[]{120, 240, 240, 360, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("tmmp?", new int[]{120, 240, 240, 360, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("tmmt?", new int[]{120, 240, 240, 360, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("tmmm?", new int[]{120, 240, 240, 360, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("mppp?", new int[]{240, 360, 0, 120, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("mppt?", new int[]{240, 360, 0, 120, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("mppm?", new int[]{240, 360, 0, 120, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("mptp?", new int[]{240, 360, 0, 120, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("mptt", new int[]{240, 360, 0, 120, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("mptm?", new int[]{240, 360, 0, 120, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("mpmp?", new int[]{240, 360, 0, 120, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("mpmt?", new int[]{240, 360, 0, 120, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("mpmm?", new int[]{240, 360, 0, 120, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("mtpp", new int[]{240, 360, 120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("mtpt", new int[]{240, 360, 120, 240, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("mtpm?", new int[]{240, 360, 120, 240, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("mttp", new int[]{240, 360, 120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("mttt", new int[]{240, 360, 120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("mttm", new int[]{240, 360, 120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("mtmp?", new int[]{240, 360, 120, 240, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("mtmt", new int[]{240, 360, 120, 240, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("mtmm", new int[]{240, 360, 120, 240, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("mmpp?", new int[]{240, 360, 240, 360, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("mmpt?", new int[]{240, 360, 240, 360, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("mmpm?", new int[]{240, 360, 240, 360, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("mmtp", new int[]{240, 360, 240, 360, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("mmtt", new int[]{240, 360, 240, 360, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("mmtm", new int[]{240, 360, 240, 360, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("mmmp?", new int[]{240, 360, 240, 360, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("mmmt", new int[]{240, 360, 240, 360, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("mmmm", new int[]{240, 360, 240, 360, 240, 360, 240, 360}));
        this.names.put("lys", arrayList);
        arrayList = new ArrayList();
        arrayList.add(new NamedRot("ppp_?", new int[]{0, 120, 0, 120, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("ppt_?", new int[]{0, 120, 0, 120, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("ppm_?", new int[]{0, 120, 0, 120, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("ptp85", new int[]{0, 120, 120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("ptp180", new int[]{0, 120, 120, 240, 0, 120, 120, 360}));
        arrayList.add(new NamedRot("ptt85", new int[]{0, 120, 120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("ptt180", new int[]{0, 120, 120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("ptt-85", new int[]{0, 120, 120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("ptm85", new int[]{0, 120, 120, 240, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("ptm180", new int[]{0, 120, 120, 240, 240, 360, 120, 360}));
        arrayList.add(new NamedRot("pmp_?", new int[]{0, 120, 240, 360, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("pmt_?", new int[]{0, 120, 240, 360, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("pmm_?", new int[]{0, 120, 240, 360, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("tpp85", new int[]{120, 240, 0, 120, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("tpp180", new int[]{120, 240, 0, 120, 0, 120, 120, 360}));
        arrayList.add(new NamedRot("tpt85", new int[]{120, 240, 0, 120, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("tpt180", new int[]{120, 240, 0, 120, 120, 240, 120, 360}));
        arrayList.add(new NamedRot("tpm_?", new int[]{120, 240, 0, 120, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("ttp85", new int[]{120, 240, 120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("ttp180", new int[]{120, 240, 120, 240, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("ttp-105", new int[]{120, 240, 120, 240, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("ttt85", new int[]{120, 240, 120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("ttt180", new int[]{120, 240, 120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("ttt-85", new int[]{120, 240, 120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("ttm105", new int[]{120, 240, 120, 240, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("ttm180", new int[]{120, 240, 120, 240, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("ttm-85", new int[]{120, 240, 120, 240, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("tmp_?", new int[]{120, 240, 240, 360, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("tmt_?", new int[]{120, 240, 240, 360, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("tmm_?", new int[]{120, 240, 240, 360, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("mpp_?", new int[]{240, 360, 0, 120, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("mpt_?", new int[]{240, 360, 0, 120, 120, 240, 0, 360}));
        arrayList.add(new NamedRot("mpm_?", new int[]{240, 360, 0, 120, 240, 360, 0, 360}));
        arrayList.add(new NamedRot("mtp85", new int[]{240, 360, 120, 240, 0, 120, 0, 120}));
        arrayList.add(new NamedRot("mtp180", new int[]{240, 360, 120, 240, 0, 120, 120, 240}));
        arrayList.add(new NamedRot("mtp-105", new int[]{240, 360, 120, 240, 0, 120, 240, 360}));
        arrayList.add(new NamedRot("mtt85", new int[]{240, 360, 120, 240, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("mtt180", new int[]{240, 360, 120, 240, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("mtt-85", new int[]{240, 360, 120, 240, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("mtm105", new int[]{240, 360, 120, 240, 240, 360, 0, 120}));
        arrayList.add(new NamedRot("mtm180", new int[]{240, 360, 120, 240, 240, 360, 120, 240}));
        arrayList.add(new NamedRot("mtm-85", new int[]{240, 360, 120, 240, 240, 360, 240, 360}));
        arrayList.add(new NamedRot("mmp_?", new int[]{240, 360, 240, 360, 0, 120, 0, 360}));
        arrayList.add(new NamedRot("mmt85", new int[]{240, 360, 240, 360, 120, 240, 0, 120}));
        arrayList.add(new NamedRot("mmt180", new int[]{240, 360, 240, 360, 120, 240, 120, 240}));
        arrayList.add(new NamedRot("mmt-85", new int[]{240, 360, 240, 360, 120, 240, 240, 360}));
        arrayList.add(new NamedRot("mmm180", new int[]{240, 360, 240, 360, 240, 360, 0, 240}));
        arrayList.add(new NamedRot("mmm-85", new int[]{240, 360, 240, 360, 240, 360, 240, 360}));
        this.names.put("arg", arrayList);
    }

    public String identify(Residue residue, ModelState modelState) {
        return this.identify(residue.getName(), this.scAngles2.measureChiAngles(residue, modelState));
    }

    public String identify(String string, double[] dArray) {
        Collection collection;
        int n;
        string = string.toLowerCase();
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = dArray[n] % 360.0;
            if (!(dArray[n] < 0.0)) continue;
            int n2 = n;
            dArray[n2] = dArray[n2] + 360.0;
        }
        if ("asp".equals(string) || "glu".equals(string) || "phe".equals(string) || "tyr".equals(string)) {
            n = dArray.length - 1;
            dArray[n] = dArray[n] % 180.0;
            if (dArray[n] < 0.0) {
                int n3 = n;
                dArray[n3] = dArray[n3] + 180.0;
            }
        }
        if ((collection = (Collection)this.names.get(string)) == null) {
            throw new IllegalArgumentException("Unknown residue type");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("No chi angles supplied");
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            throw new IllegalArgumentException("Some chi angles could not be measured");
        }
        for (NamedRot namedRot : collection) {
            if (!namedRot.contains(dArray)) continue;
            return namedRot.getName();
        }
        return null;
    }

    public double evaluate(Residue residue, ModelState modelState) {
        return this.evaluate(residue.getName(), this.scAngles2.measureChiAngles(residue, modelState));
    }

    public double evaluate(String string, double[] dArray) {
        NDFloatTable nDFloatTable = (NDFloatTable)this.tables.get(string = string.toLowerCase());
        if (nDFloatTable == null) {
            throw new IllegalArgumentException("Unknown residue type");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("No chi angles supplied");
        }
        if (dArray.length < nDFloatTable.getDimensions()) {
            throw new IllegalArgumentException("Too few chi angles supplied");
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i])) continue;
            throw new IllegalArgumentException("Some chi angles could not be measured");
        }
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return nDFloatTable.valueAt(fArray);
    }

    private static class NamedRot {
        String name;
        int[] bounds;

        public NamedRot(String string, int[] nArray) {
            this.name = string;
            this.bounds = nArray;
        }

        public boolean contains(double[] dArray) {
            for (int i = 0; i < this.bounds.length; i += 2) {
                int n = i / 2;
                if (!(dArray[n] < (double)this.bounds[i]) && !(dArray[n] > (double)this.bounds[i + 1])) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return this.name;
        }
    }
}

