/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelManager2;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.util.SoftLog;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import king.BasicTool;
import king.Plugin;
import king.ToolBox;

public abstract class ModelingTool
extends BasicTool {
    protected ModelManager2 modelman = null;

    public ModelingTool(ToolBox toolBox) {
        super(toolBox);
        List list = this.parent.getPluginList();
        for (Plugin plugin : list) {
            if (!(plugin instanceof ModelManager2)) continue;
            this.modelman = (ModelManager2)plugin;
        }
        if (this.modelman == null) {
            throw new RuntimeException("Model manager plugin not loaded");
        }
    }

    public URL getHelpURL() {
        URL uRL = ((Object)((Object)this)).getClass().getResource("tools-manual.html");
        String string = this.getHelpAnchor();
        if (uRL != null && string != null) {
            try {
                uRL = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(SoftLog.err);
            }
            return uRL;
        }
        return null;
    }

    public Residue getResidueNearest(Model model, ModelState modelState, double d, double d2, double d3) {
        Triple triple = new Triple(d, d2, d3);
        double d4 = Double.MAX_VALUE;
        AtomState atomState = null;
        modelState = modelState.createCollapsed();
        for (AtomState atomState2 : modelState.getLocalStateMap().values()) {
            double d5 = triple.sqDistance(atomState2);
            if (!model.contains(atomState2.getResidue()) || !(d5 < d4)) continue;
            d4 = d5;
            atomState = atomState2;
        }
        if (atomState == null) {
            return null;
        }
        return atomState.getResidue();
    }

    public static Collection getDependencies() {
        Collection collection = BasicTool.getDependencies();
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        arrayList.add(ModelManager2.class.getName());
        return arrayList;
    }
}

