/*
 * Decompiled with CFR 0.152.
 */
package king.tool.util;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.util.ReflectiveRunnable;
import driftwood.util.SoftLog;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import king.KingPrefs;
import king.Plugin;
import king.ToolBox;

public class SelfUpdatePlugin
extends Plugin {
    static final String UPDATE_ANYWAY = "It appears that either you already have the latest version of KiNG,\nor that you are not connected to the network at this time.\n\nDo you still want to try updating KiNG?";
    static final String ARE_YOU_SURE1 = "This plugin will download the latest version of KiNG and probe\nthat is publicly available on the Kinemage website.\nIt will then be installed over top of your current KiNG\n(";
    static final String ARE_YOU_SURE2 = "),\ncompletely replacing it.\n\nThis action cannot be undone. Furthermore, there is always\na small chance it may not perform correctly, potentially\nrendering KiNG unusable and forcing you to reinstall manually.\nAre you sure you want to continue?";
    static final String UPDATE_FAILED = "Due to circumstances beyond our control, the update failed.\nThe most likely source of error is that you don't have permission\nto overwrite the KiNG installation, or that the network is down.\nMore details about the error are available under Help | Error Log.\n\nYour copy of KiNG is probably OK, but it COULD have been damaged --\nif it acts strangely or refuses to start, you may have to reinstall.\nYou can get a new copy of KiNG from http://kinemage.biochem.duke.edu.\n\nWe are very sorry this happened. If you believe this is the result of\na bug in KiNG or in this plugin, please report it to the author/maintainter,\nwhose email address is listed in the user manual.";
    static final String ABORT_OK = "The update has been aborted.\nNo changes have been made to KiNG.";
    static final String UPDATE_OK = "The update appears to have succeeded.\nCross your fingers and restart KiNG\nfor changes to take effect.";
    Timer progressTimer = new Timer(1000, new ReflectiveAction(null, null, this, "onProgressTimer"));
    JProgressBar progressBar;
    JDialog dialog;
    volatile int totalSize = 1;
    volatile int downloadedSize = 0;
    volatile boolean abortFlag = false;
    volatile Throwable backgroundError = null;

    public SelfUpdatePlugin(ToolBox toolBox) {
        super(toolBox);
        this.progressTimer.setCoalesce(true);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        JButton jButton = new JButton(new ReflectiveAction("Cancel", null, this, "onDownloadCancel"));
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.insets(4).memorize();
        tablePane2.addCell(new JLabel("Downloading new version of KiNG from")).newRow();
        tablePane2.addCell(new JLabel("http://kinemage.biochem.duke.edu ...")).newRow();
        tablePane2.hfill(true).addCell(this.progressBar).newRow();
        tablePane2.center().addCell(jButton);
        this.dialog = new JDialog(this.kMain.getTopWindow(), true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setContentPane(tablePane2);
    }

    public String toString() {
        return "Update KiNG";
    }

    public static boolean isAppletSafe() {
        return false;
    }

    public JMenuItem getToolsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(new ReflectiveAction(this.toString(), null, this, "onBeginUpdate"));
        return jMenuItem;
    }

    public String getHelpAnchor() {
        return "#update-plugin";
    }

    public void onProgressTimer(ActionEvent actionEvent) {
        this.progressBar.setValue(100 * this.downloadedSize / this.totalSize);
    }

    public void onDownloadCancel(ActionEvent actionEvent) {
        this.abortFlag = true;
    }

    public void onBeginUpdate(ActionEvent actionEvent) {
        String string;
        KingPrefs kingPrefs = this.kMain.getPrefs();
        if (!kingPrefs.newerVersionAvailable() && 0 != JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), UPDATE_ANYWAY, "Update anyway?", 0)) {
            return;
        }
        try {
            string = ARE_YOU_SURE1 + kingPrefs.jarFileDirectory.getCanonicalPath() + ARE_YOU_SURE2;
        }
        catch (Exception exception) {
            string = "This plugin will download the latest version of KiNG and probe\nthat is publicly available on the Kinemage website.\nIt will then be installed over top of your current KiNG\n(unknown location),\ncompletely replacing it.\n\nThis action cannot be undone. Furthermore, there is always\na small chance it may not perform correctly, potentially\nrendering KiNG unusable and forcing you to reinstall manually.\nAre you sure you want to continue?";
        }
        if (0 != JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), string, "Update KiNG?", 0)) {
            return;
        }
        this.downloadedSize = 0;
        this.abortFlag = false;
        this.backgroundError = null;
        this.progressBar.setValue(0);
        Thread thread = new Thread(new ReflectiveRunnable(this, "downloadFile"));
        thread.start();
        this.progressTimer.start();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.kMain.getTopWindow());
        this.dialog.setVisible(true);
    }

    public void downloadFile() {
        try {
            int n;
            URL uRL = new URL("http://kinemage.biochem.duke.edu/downloads/software/king/current2");
            URLConnection uRLConnection = uRL.openConnection();
            this.totalSize = uRLConnection.getContentLength();
            this.downloadedSize = 0;
            InputStream inputStream = uRLConnection.getInputStream();
            File file = File.createTempFile("kingupdate", null);
            file.deleteOnExit();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1 && !this.abortFlag) {
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                this.downloadedSize += n;
            }
            ((OutputStream)bufferedOutputStream).close();
            inputStream.close();
            if (!this.abortFlag) {
                ZipFile zipFile = new ZipFile(file);
                this.installZipFile(zipFile);
                zipFile.close();
                ZipFile zipFile2 = this.updateProbe();
                this.installZipFile(zipFile2);
                zipFile2.close();
                this.abortFlag = false;
            }
        }
        catch (Throwable throwable) {
            this.backgroundError = throwable;
        }
        SwingUtilities.invokeLater(new ReflectiveRunnable(this, "onFinishUpdate"));
    }

    private ZipFile updateProbe() throws Throwable {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("win") != -1) {
            return this.downloadProbe("http://kinemage.biochem.duke.edu/downloads/software/king/windowsprobe");
        }
        if (string.indexOf("mac") != -1) {
            return this.downloadProbe("http://kinemage.biochem.duke.edu/downloads/software/king/macprobe");
        }
        if (string.indexOf("nix") != -1 || string.indexOf("nux") != -1) {
            return this.downloadProbe("http://kinemage.biochem.duke.edu/downloads/software/king/linuxprobe");
        }
        JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Unable to determine operating system name, please update manually.", "Update failed", 0);
        return null;
    }

    private ZipFile downloadProbe(String string) throws Throwable {
        int n;
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        this.totalSize = uRLConnection.getContentLength();
        this.downloadedSize = 0;
        InputStream inputStream = uRLConnection.getInputStream();
        File file = File.createTempFile("probeupdate", null);
        file.deleteOnExit();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1 && !this.abortFlag) {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
            this.downloadedSize += n;
        }
        ((OutputStream)bufferedOutputStream).close();
        inputStream.close();
        return new ZipFile(file);
    }

    private void installZipFile(ZipFile zipFile) throws IOException {
        File file = this.kMain.getPrefs().jarFileDirectory;
        if (!(file.exists() && file.isDirectory() && file.canWrite())) {
            throw new IOException("Unable to unpack downloaded ZIP into " + file + "; check permissions/ownership?");
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            int n = string.indexOf("/");
            if (n != -1) {
                string = string.substring(n);
            }
            if (string.equals("")) continue;
            File file2 = new File(file, string).getCanonicalFile();
            if (zipEntry.isDirectory()) {
                file2.mkdirs();
                continue;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            this.streamcopy(inputStream, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).close();
            inputStream.close();
        }
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void onFinishUpdate() {
        this.progressTimer.stop();
        this.dialog.setVisible(false);
        if (this.backgroundError != null) {
            this.backgroundError.printStackTrace(SoftLog.err);
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), UPDATE_FAILED, "Update failed", 0);
        } else if (this.abortFlag) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), ABORT_OK, "Update aborted", 1);
        } else {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), UPDATE_OK, "Update succeeded", 1);
        }
    }
}

