/*
 * Decompiled with CFR 0.152.
 */
package king.io;

import driftwood.util.SoftLog;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public class KinfileTokenizer {
    static final String TYPE_NONE = "nil-type";
    static final String TYPE_IDENTIFIER = "identifier";
    static final String TYPE_COMMENT = "comment";
    static final String TYPE_ASPECT = "aspect";
    static final String TYPE_SINGLE_QUOTE = "s-quote";
    static final String TYPE_DOUBLE_QUOTE = "d-quote";
    static final String TYPE_KEYWORD = "keyword";
    static final String TYPE_PROPERTY = "property";
    static final String TYPE_INTEGER = "integer";
    static final String TYPE_NUMBER = "number";
    static final String TYPE_LITERAL = "literal";
    static final int NIL_CHARACTER = -1;
    LineNumberReader in;
    char[] buffer = new char[256];
    int bufferIndex = 0;
    int firstChar;
    long charsRead;
    String stringValue;
    double doubleValue;
    String type;
    boolean isBOL;
    boolean isEOF;

    public KinfileTokenizer(LineNumberReader lineNumberReader) throws IOException {
        this.in = lineNumberReader;
        this.charsRead = 0L;
        this.isEOF = false;
        this.firstChar = 10;
        this.advance();
    }

    void bufferAppend(char c) {
        if (this.bufferIndex >= this.buffer.length) {
            char[] cArray = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray, 0, this.buffer.length);
            this.buffer = cArray;
            this.error("Token too long; increased buffer size to " + this.buffer.length);
        }
        this.buffer[this.bufferIndex++] = c;
    }

    String bufferToString() {
        return new String(this.buffer, 0, this.bufferIndex);
    }

    void bufferClear() {
        this.bufferIndex = 0;
    }

    int in_read() throws IOException {
        ++this.charsRead;
        return this.in.read();
    }

    public long getCharsRead() {
        return this.charsRead;
    }

    void error(String string) {
        SoftLog.err.println("[line " + (this.in.getLineNumber() + 1) + "] " + string);
    }

    public void advance() throws IOException {
        this.stringValue = null;
        this.doubleValue = Double.NaN;
        this.type = TYPE_NONE;
        this.isBOL = false;
        this.bufferClear();
        int n = this.firstChar > 0 ? this.firstChar : this.in_read();
        this.firstChar = -1;
        while (n == 32 || n == 10 || n == 44 || n == 9 || n == 12) {
            this.isBOL = n == 10;
            n = this.in_read();
        }
        if (n == -1) {
            this.isEOF = true;
            return;
        }
        if (n == 123) {
            this.readQuoted('{', '}');
            this.type = TYPE_IDENTIFIER;
        } else if (n == 60) {
            this.readQuoted('<', '>');
            this.type = TYPE_COMMENT;
        } else if (n == 40) {
            this.readQuoted('(', ')');
            this.type = TYPE_ASPECT;
        } else if (n == 39) {
            this.readQuoted('\'');
            this.type = TYPE_SINGLE_QUOTE;
        } else if (n == 34) {
            this.readQuoted('\"');
            this.type = TYPE_DOUBLE_QUOTE;
        } else {
            this.bufferAppend((char)n);
            this.readUnquoted();
        }
        this.bufferClear();
    }

    public String advanceToKeyword() throws IOException {
        this.stringValue = null;
        this.doubleValue = Double.NaN;
        this.type = TYPE_NONE;
        this.isBOL = false;
        this.bufferClear();
        int n = this.firstChar > 0 ? this.firstChar : this.in_read();
        this.firstChar = -1;
        StringBuffer stringBuffer = new StringBuffer(1024);
        while (!this.isBOL || n != 64) {
            stringBuffer.append((char)n);
            boolean bl = this.isBOL = n == 10;
            n = this.in_read();
            if (n != -1) continue;
            this.isEOF = true;
            return stringBuffer.toString();
        }
        String string = stringBuffer.toString();
        this.bufferAppend((char)n);
        this.readUnquoted();
        this.bufferClear();
        return string;
    }

    void readQuoted(char c, char c2) throws IOException {
        int n = 1;
        while (n > 0) {
            int n2 = this.in_read();
            if (n2 == -1) {
                n = 0;
                this.error("Quoted token terminated by EOF; type = " + c + "" + c2);
                continue;
            }
            if (n2 == c) {
                ++n;
                this.bufferAppend((char)n2);
                continue;
            }
            if (n2 == c2) {
                if (--n <= 0) continue;
                this.bufferAppend((char)n2);
                continue;
            }
            this.bufferAppend((char)n2);
        }
        this.stringValue = this.bufferToString();
        this.doubleValue = Double.NaN;
    }

    void readQuoted(char c) throws IOException {
        int n = 1;
        while (n > 0) {
            int n2 = this.in_read();
            if (n2 == -1) {
                n = 0;
                this.error("Quoted token terminated by EOF; type = " + c + "" + c);
                continue;
            }
            if (n2 == c) {
                --n;
                continue;
            }
            this.bufferAppend((char)n2);
        }
        this.stringValue = this.bufferToString();
        this.doubleValue = Double.NaN;
    }

    void readUnquoted() throws IOException {
        block14: {
            int n;
            while (true) {
                if ((n = this.in_read()) == -1 || n == 32 || n == 10 || n == 44 || n == 9 || n == 12 || n == 123 || n == 60 || n == 40 || n == 39 || n == 34) {
                    this.firstChar = n;
                    break;
                }
                if (n == 61) {
                    this.bufferAppend((char)n);
                    break;
                }
                this.bufferAppend((char)n);
            }
            while (n == 32 || n == 44 || n == 9) {
                n = this.in_read();
                if (n == 61) {
                    this.bufferAppend('=');
                    this.firstChar = -1;
                    continue;
                }
                this.firstChar = n;
            }
            this.stringValue = this.bufferToString();
            this.doubleValue = Double.NaN;
            n = this.stringValue.charAt(0);
            if (this.stringValue.startsWith("@") && this.isBOL()) {
                this.type = TYPE_KEYWORD;
            } else if (this.stringValue.endsWith("=")) {
                this.type = TYPE_PROPERTY;
            } else if (48 <= n && n <= 57 || n == 46 || n == 45 || n == 43) {
                try {
                    this.doubleValue = Double.parseDouble(this.stringValue);
                    if (this.doubleValue == Math.rint(this.doubleValue)) {
                        this.type = TYPE_INTEGER;
                        break block14;
                    }
                    this.type = TYPE_NUMBER;
                }
                catch (NumberFormatException numberFormatException) {
                    this.type = TYPE_LITERAL;
                }
            } else {
                this.type = TYPE_LITERAL;
            }
        }
    }

    public boolean isBOL() {
        return this.isBOL;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    public boolean isIdentifier() {
        return this.type == TYPE_IDENTIFIER;
    }

    public boolean isComment() {
        return this.type == TYPE_COMMENT;
    }

    public boolean isAspect() {
        return this.type == TYPE_ASPECT;
    }

    public boolean isSingleQuote() {
        return this.type == TYPE_SINGLE_QUOTE;
    }

    public boolean isDoubleQuote() {
        return this.type == TYPE_DOUBLE_QUOTE;
    }

    public boolean isKeyword() {
        return this.type == TYPE_KEYWORD;
    }

    public boolean isProperty() {
        return this.type == TYPE_PROPERTY;
    }

    public boolean isInteger() {
        return this.type == TYPE_INTEGER;
    }

    public boolean isNumber() {
        return this.type == TYPE_NUMBER || this.type == TYPE_INTEGER;
    }

    public boolean isLiteral() {
        return this.type == TYPE_LITERAL;
    }

    public String getType() {
        return this.type;
    }

    public String getString() {
        return this.stringValue;
    }

    public int getInt() {
        if (!this.isInteger() || Double.isNaN(this.doubleValue) || this.doubleValue != Math.rint(this.doubleValue)) {
            throw new IllegalStateException("[line " + (this.in.getLineNumber() + 1) + "] Token is not an integer");
        }
        return (int)this.doubleValue;
    }

    public float getFloat() {
        if (!this.isNumber() || Double.isNaN(this.doubleValue)) {
            throw new IllegalStateException("[line " + (this.in.getLineNumber() + 1) + "] Token is not a number");
        }
        return (float)this.doubleValue;
    }

    public double getDouble() {
        if (!this.isNumber() || Double.isNaN(this.doubleValue)) {
            throw new IllegalStateException("[line " + (this.in.getLineNumber() + 1) + "] Token is not a number");
        }
        return this.doubleValue;
    }

    public void Main(boolean bl) throws IOException {
        if (bl) {
            System.out.println("<div class='kin2html'>");
            while (!this.isEOF()) {
                String string;
                String string2;
                String string3 = this.getString();
                if (this.isBOL()) {
                    System.out.print("\n<br />");
                }
                if (this.isIdentifier()) {
                    string2 = "{";
                    string = "}";
                } else if (this.isComment()) {
                    string2 = "&lt;";
                    string = "&gt;";
                } else if (this.isAspect()) {
                    string2 = "(";
                    string = ")";
                } else if (this.isSingleQuote()) {
                    string2 = "'";
                    string = "'";
                } else if (this.isDoubleQuote()) {
                    string2 = "\"";
                    string = "\"";
                } else {
                    string2 = "";
                    string = "";
                }
                System.out.print("<span class='" + this.getType() + "'>" + string2 + string3 + string + "</span> ");
                if (this.isKeyword() && (string3.equals("@text") || string3.equals("@caption"))) {
                    System.out.print("\n<pre>");
                    System.out.print(this.advanceToKeyword());
                    System.out.print("</pre>\n");
                    continue;
                }
                this.advance();
            }
            System.out.println("\n</div>");
        } else {
            long l = System.currentTimeMillis();
            while (!this.isEOF()) {
                String string = this.getString();
                if (this.isKeyword() && (string.equals("@text") || string.equals("@caption"))) {
                    System.out.println("[>>> " + string + "]");
                    System.out.println(this.advanceToKeyword());
                    System.out.println("[<<< " + string + "]");
                    continue;
                }
                if (this.isBOL()) {
                    System.out.println("[BOL:" + KinfileTokenizer.justifyLeft(this.getType(), 10) + "] " + string);
                } else {
                    System.out.println("[    " + KinfileTokenizer.justifyLeft(this.getType(), 10) + "] " + string);
                }
                this.advance();
            }
            l = System.currentTimeMillis() - l;
            System.out.println("END OF FILE (" + l + " ms)");
            System.out.println();
            System.out.println();
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-css".equals(stringArray[i])) {
                bl = true;
                continue;
            }
            System.err.println("*** Takes a kinemage on stdin and writes tokens to stdout.");
        }
        try {
            new KinfileTokenizer(new LineNumberReader(new InputStreamReader(System.in))).Main(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public static String justifyLeft(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.ensureCapacity(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

