/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.SwapBox;
import driftwood.gui.TablePane2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.core.KPaint;
import king.core.KPalette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPicker
extends TablePane2
implements MouseListener {
    protected int backgroundMode;
    protected Dimension patchSize;
    protected Component filler;
    protected SwapBox extraPatchBox;
    protected Color background;
    protected Color highlight;
    protected ColorPatch selectedPatch = null;
    protected Map<String, ColorPatch> patchMap = new HashMap<String, ColorPatch>();
    protected Map<String, ColorPatch> extraMap = new HashMap<String, ColorPatch>();
    protected Collection<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    int maxNumNewColors = 36;

    public ColorPicker(int n, int n2) {
        this.patchSize = new Dimension(n2, n2);
        this.filler = Box.createRigidArea(this.patchSize);
        this.extraPatchBox = new SwapBox(null);
        this.setBackgroundMode(n);
        this.setToolTipText("Click empty space to deselect all colors");
        this.addMouseListener(this);
        this.addPatch(KPalette.red);
        this.addPatch(KPalette.pink);
        this.addPatch(KPalette.pinktint);
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.orange);
        this.addPatch(KPalette.peach);
        this.addPatch(KPalette.peachtint);
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.gold);
        this.addFiller();
        this.addFiller();
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.yellow);
        this.addPatch(KPalette.yellow);
        this.addPatch(KPalette.yellowtint);
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.lime);
        this.addFiller();
        this.addFiller();
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.green);
        this.addPatch(KPalette.sea);
        this.addPatch(KPalette.greentint);
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.sea);
        this.addFiller();
        this.addFiller();
        this.addPatch(KPalette.white);
        this.newRow();
        this.addPatch(KPalette.cyan);
        this.addFiller();
        this.addFiller();
        this.addPatch(KPalette.gray);
        this.newRow();
        this.addPatch(KPalette.sky);
        this.addFiller();
        this.addFiller();
        this.addPatch(KPalette.brown);
        this.newRow();
        this.addPatch(KPalette.blue);
        this.addPatch(KPalette.sky);
        this.addPatch(KPalette.bluetint);
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.purple);
        this.addPatch(KPalette.lilac);
        this.addPatch(KPalette.lilactint);
        this.addFiller();
        this.newRow();
        this.addPatch(KPalette.magenta);
        this.addFiller();
        this.addFiller();
        this.addPatch(KPalette.deadwhite);
        this.newRow();
        this.addPatch(KPalette.hotpink);
        this.addFiller();
        this.addPatch(KPalette.invisible);
        this.addPatch(KPalette.deadblack);
        this.newRow();
        this.insets(0).hfill(true).vfill(true);
        this.addCell(this.extraPatchBox, 4, 1);
    }

    private void addPatch(KPaint kPaint) {
        ColorPatch colorPatch = new ColorPatch(kPaint);
        this.addCell(colorPatch);
        this.patchMap.put(kPaint.toString(), colorPatch);
    }

    private void addFiller() {
        this.addCell(this.filler);
    }

    protected void selectPatch(ColorPatch colorPatch) {
        if (this.selectedPatch != null) {
            this.selectedPatch.isSelected = false;
            this.selectedPatch.repaint();
        }
        this.selectedPatch = colorPatch;
        if (this.selectedPatch != null) {
            this.selectedPatch.isSelected = true;
            this.selectedPatch.repaint();
        }
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public KPaint getSelection() {
        if (this.selectedPatch == null) {
            return null;
        }
        return this.selectedPatch.paint;
    }

    public void setSelection(String string) {
        ColorPatch colorPatch = this.patchMap.get(string);
        if (colorPatch == null) {
            colorPatch = this.extraMap.get(string);
        }
        this.selectPatch(colorPatch);
    }

    public void setSelection(KPaint kPaint) {
        if (kPaint == null) {
            this.setSelection((String)null);
        } else {
            this.setSelection(kPaint.toString());
        }
    }

    public int getBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(int n) {
        this.backgroundMode = n;
        if (this.backgroundMode == 0) {
            this.background = KPaint.black;
            this.highlight = KPaint.white;
        } else if (this.backgroundMode == 2) {
            this.background = KPaint.black;
            this.highlight = KPaint.white;
        } else if (this.backgroundMode == 1) {
            this.background = KPaint.white;
            this.highlight = KPaint.black;
        } else if (this.backgroundMode == 3) {
            this.background = KPaint.white;
            this.highlight = KPaint.black;
        }
        this.setOpaque(true);
        this.setBackground(this.background);
        this.repaint();
    }

    public void setExtras(Collection<KPaint> collection) {
        this.extraPatchBox.setTarget(null);
        this.extraMap.clear();
        if (collection == null) {
            return;
        }
        int n = 0;
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.setOpaque(false);
        for (KPaint kPaint : collection) {
            if (n >= this.maxNumNewColors) {
                System.err.println("Too many user-defined colors: " + collection.size() + " (max = " + this.maxNumNewColors + ")");
                break;
            }
            ColorPatch colorPatch = new ColorPatch(kPaint);
            tablePane2.addCell(colorPatch);
            this.extraMap.put(kPaint.toString(), colorPatch);
            if (++n % 4 != 0) continue;
            tablePane2.newRow();
        }
        this.extraPatchBox.setTarget(tablePane2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.selectPatch(null);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected class ColorPatch
    extends JComponent
    implements MouseListener {
        KPaint paint;
        boolean isSelected = false;

        protected ColorPatch(KPaint kPaint) {
            this.paint = kPaint;
            this.setMinimumSize(ColorPicker.this.patchSize);
            this.setPreferredSize(ColorPicker.this.patchSize);
            this.setMaximumSize(ColorPicker.this.patchSize);
            this.setToolTipText(kPaint.toString());
            this.addMouseListener(this);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Dimension dimension = this.getSize();
            Color[] colorArray = this.paint.getPaints(ColorPicker.this.backgroundMode);
            int n = 0;
            int n2 = dimension.height / 2;
            for (int i = 15; i >= 0; --i) {
                graphics2D.setPaint(colorArray[i]);
                graphics2D.fillRect(0, n, dimension.width, n2);
                n2 = (dimension.height - (n += n2)) / (i < 1 ? 1 : i);
            }
            if (this.isSelected) {
                graphics2D.setPaint(ColorPicker.this.highlight);
                graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ColorPicker.this.selectPatch(this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

