/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import driftwood.r3.MutableTuple3;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;

public class SuperPoser {
    int len;
    Triple[] ref;
    Triple[] mob;
    double[] w;
    Triple refCentroid;
    Triple mobCentroid;

    public SuperPoser(Tuple3[] tuple3Array, Tuple3[] tuple3Array2) {
        this(tuple3Array, 0, tuple3Array2, 0, Math.max(tuple3Array.length, tuple3Array2.length));
    }

    public SuperPoser(Tuple3[] tuple3Array, int n, Tuple3[] tuple3Array2, int n2, int n3) {
        this.reset(tuple3Array, n, tuple3Array2, n2, n3);
    }

    public void reset(Tuple3[] tuple3Array, Tuple3[] tuple3Array2) {
        this.reset(tuple3Array, 0, tuple3Array2, 0, Math.max(tuple3Array.length, tuple3Array2.length));
    }

    public void reset(Tuple3[] tuple3Array, int n, Tuple3[] tuple3Array2, int n2, int n3) {
        int n4;
        if (n + n3 > tuple3Array.length || n2 + n3 > tuple3Array2.length) {
            throw new IllegalArgumentException("Not enough points in m1 and/or m2");
        }
        this.len = n3;
        if (this.ref == null || this.ref.length < this.len) {
            this.ref = new Triple[this.len];
            this.mob = new Triple[this.len];
            this.w = new double[this.len];
            for (n4 = 0; n4 < this.len; ++n4) {
                this.ref[n4] = new Triple(tuple3Array[n4 + n]);
                this.mob[n4] = new Triple(tuple3Array2[n4 + n2]);
                this.w[n4] = 1.0;
            }
        } else {
            for (n4 = 0; n4 < this.len; ++n4) {
                this.ref[n4].like(tuple3Array[n4 + n]);
                this.mob[n4].like(tuple3Array2[n4 + n2]);
                this.w[n4] = 1.0;
            }
        }
        this.refCentroid = this.calcCentroid(this.ref);
        this.mobCentroid = this.calcCentroid(this.mob);
        for (n4 = 0; n4 < this.len; ++n4) {
            this.ref[n4].sub(this.refCentroid);
            this.mob[n4].sub(this.mobCentroid);
        }
    }

    private static double get(Tuple3 tuple3, int n) {
        switch (n) {
            case 1: {
                return tuple3.getX();
            }
            case 2: {
                return tuple3.getY();
            }
            case 3: {
                return tuple3.getZ();
            }
        }
        throw new IllegalArgumentException("Index must be 1, 2, or 3");
    }

    private static void set(MutableTuple3 mutableTuple3, int n, double d) {
        switch (n) {
            case 1: {
                mutableTuple3.setX(d);
                break;
            }
            case 2: {
                mutableTuple3.setY(d);
                break;
            }
            case 3: {
                mutableTuple3.setZ(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index must be 1, 2, or 3");
            }
        }
    }

    Triple calcCentroid(Triple[] tripleArray) {
        Triple triple = new Triple();
        for (int i = 0; i < this.len; ++i) {
            triple.add(tripleArray[i]);
        }
        triple.mult(1.0 / (double)this.len);
        return triple;
    }

    public double calcRMSD(Transform transform) {
        double d = 0.0;
        Triple triple = new Triple();
        for (int i = 0; i < this.len; ++i) {
            transform.transformVector(this.mob[i], triple);
            triple.sub(this.ref[i]);
            d += this.w[i] * triple.mag2();
        }
        return Math.sqrt(d / (double)this.len);
    }

    public Transform superpos() {
        int n;
        int n2;
        Transform transform = new Transform();
        Transform transform2 = new Transform();
        Transform transform3 = new Transform();
        Triple triple = new Triple();
        Triple triple2 = new Triple();
        Triple triple3 = new Triple();
        Triple triple4 = new Triple();
        Triple triple5 = new Triple();
        for (n2 = 1; n2 <= 3; ++n2) {
            for (n = 1; n <= 3; ++n) {
                double d = 0.0;
                for (int i = 0; i < this.len; ++i) {
                    d += this.w[i] * SuperPoser.get(this.mob[i], n2) * SuperPoser.get(this.ref[i], n);
                }
                transform.set(n2, n, d);
            }
        }
        for (int i = 0; i < 18; ++i) {
            triple2.setX(transform.get(2, 3) - transform.get(3, 2));
            triple2.setY(transform.get(3, 1) - transform.get(1, 3));
            triple2.setZ(transform.get(1, 2) - transform.get(2, 1));
            double d = triple2.mag2();
            if (i % 3 == 0) {
                triple4.like(triple2);
            } else {
                triple4.like(triple3).mult(d / triple.mag2()).add(triple2);
            }
            triple.like(triple2);
            triple3.like(triple4);
            triple5.like(triple4).unit();
            double d2 = transform.get(1, 1) + transform.get(2, 2) + transform.get(3, 3);
            double d3 = triple2.dot(triple5);
            double d4 = 0.0;
            for (n2 = 1; n2 <= 3; ++n2) {
                for (n = 1; n <= 3; ++n) {
                    d4 += SuperPoser.get(triple5, n2) * (d2 * (double)(n2 == n ? 1 : 0) - 0.5 * (transform.get(n2, n) + transform.get(n, n2))) * SuperPoser.get(triple5, n);
                }
            }
            double d5 = Math.toDegrees(Math.atan2(d3, d4));
            if (triple5.mag2() > 1.0E-12) {
                transform3.likeRotation(triple5, d5);
                transform2.premult(transform3);
                transform.premult(transform3);
            }
            if (i % 3 == 2 && (d < 1.0E-12 || d5 < 1.0E-6)) break;
        }
        triple5.like(this.mobCentroid).neg();
        transform3.likeTranslation(triple5);
        transform2.postmult(transform3);
        transform3.likeTranslation(this.refCentroid);
        transform2.premult(transform3);
        return transform2;
    }
}

