/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.visitor;

import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;

public class ResourceFilePresenceFilter
implements ResourceFileVisitor {
    private final ResourceFilePool resourceFilePool;
    private final ResourceFileVisitor presentResourceFileVisitor;
    private final ResourceFileVisitor missingResourceFileVisitor;

    public ResourceFilePresenceFilter(ResourceFilePool resourceFilePool, ResourceFileVisitor presentResourceFileVisitor, ResourceFileVisitor missingResourceFileVisitor) {
        this.resourceFilePool = resourceFilePool;
        this.presentResourceFileVisitor = presentResourceFileVisitor;
        this.missingResourceFileVisitor = missingResourceFileVisitor;
    }

    @Override
    public void visitResourceFile(ResourceFile resourceFile) {
        ResourceFileVisitor resourceFileVisitor = this.resourceFileVisitor(resourceFile);
        if (resourceFileVisitor != null) {
            resourceFileVisitor.visitResourceFile(resourceFile);
        }
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        ResourceFileVisitor resourceFileVisitor = this.resourceFileVisitor(kotlinModule);
        if (resourceFileVisitor != null) {
            resourceFileVisitor.visitResourceFile(kotlinModule);
        }
    }

    private ResourceFileVisitor resourceFileVisitor(ResourceFile resourceFile) {
        return this.resourceFilePool.getResourceFile(resourceFile.getFileName()) != null ? this.presentResourceFileVisitor : this.missingResourceFileVisitor;
    }
}

