/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ProgramMethodOptimizationInfo;

public class UnusedParameterOptimizationInfoUpdater
implements AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(UnusedParameterOptimizationInfoUpdater.class);
    private final MemberVisitor extraUnusedParameterMethodVisitor;

    public UnusedParameterOptimizationInfoUpdater() {
        this(null);
    }

    public UnusedParameterOptimizationInfoUpdater(MemberVisitor extraUnusedParameterMethodVisitor) {
        this.extraUnusedParameterMethodVisitor = extraUnusedParameterMethodVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        logger.debug("UnusedParameterOptimizationInfoUpdater: {}.{}{}", (Object)clazz.getName(), (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
        int oldParameterSize = ParameterUsageMarker.getParameterSize(method);
        int newParameterSize = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        if (oldParameterSize > newParameterSize) {
            ProgramMethodOptimizationInfo programMethodOptimizationInfo = ProgramMethodOptimizationInfo.getProgramMethodOptimizationInfo(method);
            ArrayList<Integer> removedParameters = new ArrayList<Integer>();
            int parameterIndex = 0;
            int variableIndex = 0;
            while (variableIndex < oldParameterSize) {
                if (!ParameterUsageMarker.isParameterUsed(method, variableIndex)) {
                    logger.debug("  Deleting parameter #{} (v{})", (Object)parameterIndex, (Object)variableIndex);
                    removedParameters.add(parameterIndex);
                }
                variableIndex += programMethodOptimizationInfo.getParameterSize(parameterIndex);
                ++parameterIndex;
            }
            for (int i = removedParameters.size() - 1; i >= 0; --i) {
                programMethodOptimizationInfo.removeParameter((Integer)removedParameters.get(i));
            }
            programMethodOptimizationInfo.setParameterSize(newParameterSize);
            programMethodOptimizationInfo.updateUsedParameters(-1L);
            if (this.extraUnusedParameterMethodVisitor != null) {
                method.accept(clazz, this.extraUnusedParameterMethodVisitor);
            }
        }
    }
}

