/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class NewMemberNameFilter
implements MemberVisitor {
    private final MemberVisitor memberVisitor;

    public NewMemberNameFilter(MemberVisitor memberVisitor) {
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.hasName(programField)) {
            this.memberVisitor.visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.hasName(programClass, programMethod)) {
            this.memberVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.hasName(libraryField)) {
            this.memberVisitor.visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.hasName(libraryClass, libraryMethod)) {
            this.memberVisitor.visitLibraryMethod(libraryClass, libraryMethod);
        }
    }

    private boolean hasName(Clazz clazz) {
        return ClassObfuscator.newClassName(clazz) != null;
    }

    private boolean hasName(Clazz clazz, Method method) {
        return this.hasName(method) || this.hasName(clazz) && method.getName(clazz).equals("<init>");
    }

    private boolean hasName(Member member) {
        return MemberObfuscator.newMemberName(member) != null;
    }
}

