/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;

public class GetEnclosingClassChecker
implements ConstantVisitor {
    private final WarningPrinter notePrinter;

    public GetEnclosingClassChecker(WarningPrinter notePrinter) {
        this.notePrinter = notePrinter;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        String methodName;
        String className = methodrefConstant.getClassName(clazz);
        if (className.equals("java/lang/Class") && ((methodName = methodrefConstant.getName(clazz)).equals("getEnclosingClass") || methodName.equals("getDeclaringClass"))) {
            this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " calls '" + ClassUtil.externalShortClassName(ClassUtil.externalClassName(className)) + "." + methodName + "'");
        }
    }
}

