/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.EntityManagerPlusOperations;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendedEntityManagerCreator {
    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, plusOperations, null, null, false);
    }

    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, plusOperations, exceptionTranslator, null, false);
    }

    public static EntityManager createApplicationManagedEntityManager(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, false);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, plusOperations, null, null, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManager rawEntityManager, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, plusOperations, exceptionTranslator, null, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo) {
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, true);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf) {
        return ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, null);
    }

    public static EntityManager createContainerManagedEntityManager(EntityManagerFactory emf, Map properties) {
        Assert.notNull(emf, "EntityManagerFactory must not be null");
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)emf;
            EntityManagerFactory nativeEmf = emfInfo.getNativeEntityManagerFactory();
            EntityManager rawEntityManager = !CollectionUtils.isEmpty(properties) ? nativeEmf.createEntityManager(properties) : nativeEmf.createEntityManager();
            return ExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo, true);
        }
        EntityManager rawEntityManager = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, null, null, null, null, null, true);
    }

    private static EntityManager createProxy(EntityManager rawEntityManager, EntityManagerFactoryInfo emfInfo, boolean containerManaged) {
        PersistenceUnitInfo pui;
        Assert.notNull(emfInfo, "EntityManagerFactoryInfo must not be null");
        JpaDialect jpaDialect = emfInfo.getJpaDialect();
        EntityManagerPlusOperations plusOperations = null;
        if (jpaDialect != null && jpaDialect.supportsEntityManagerPlusOperations()) {
            plusOperations = jpaDialect.getEntityManagerPlusOperations(rawEntityManager);
        }
        Boolean jta = (pui = emfInfo.getPersistenceUnitInfo()) != null ? Boolean.valueOf(pui.getTransactionType() == PersistenceUnitTransactionType.JTA) : null;
        return ExtendedEntityManagerCreator.createProxy(rawEntityManager, emfInfo.getEntityManagerInterface(), emfInfo.getBeanClassLoader(), plusOperations, jpaDialect, jta, containerManaged);
    }

    private static EntityManager createProxy(EntityManager rawEm, Class<? extends EntityManager> emIfc, ClassLoader cl, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator, Boolean jta, boolean containerManaged) {
        Assert.notNull(rawEm, "EntityManager must not be null");
        LinkedHashSet<Class<Object>> ifcs = new LinkedHashSet<Class<Object>>();
        if (emIfc != null) {
            ifcs.add(emIfc);
        } else {
            ifcs.addAll(ClassUtils.getAllInterfacesForClassAsSet(rawEm.getClass(), cl));
        }
        ifcs.add(EntityManagerProxy.class);
        if (plusOperations != null) {
            ifcs.add(EntityManagerPlusOperations.class);
        }
        return (EntityManager)Proxy.newProxyInstance(cl != null ? cl : ExtendedEntityManagerCreator.class.getClassLoader(), ifcs.toArray(new Class[ifcs.size()]), (InvocationHandler)new ExtendedEntityManagerInvocationHandler(rawEm, plusOperations, exceptionTranslator, jta, containerManaged));
    }

    private static class ExtendedEntityManagerSynchronization
    extends ResourceHolderSynchronization
    implements Ordered {
        private final EntityManager entityManager;
        private final PersistenceExceptionTranslator exceptionTranslator;

        public ExtendedEntityManagerSynchronization(EntityManager em, PersistenceExceptionTranslator exceptionTranslator) {
            super(new EntityManagerHolder(em), em);
            this.entityManager = em;
            this.exceptionTranslator = exceptionTranslator;
        }

        public int getOrder() {
            return 901;
        }

        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        public void afterCommit() {
            super.afterCommit();
            try {
                this.entityManager.getTransaction().commit();
            }
            catch (RuntimeException ex) {
                throw this.convertCompletionException(ex);
            }
        }

        public void afterCompletion(int status) {
            super.afterCompletion(status);
            if (status != 0) {
                try {
                    this.entityManager.getTransaction().rollback();
                }
                catch (RuntimeException ex) {
                    throw this.convertCompletionException(ex);
                }
            }
        }

        private RuntimeException convertCompletionException(RuntimeException ex) {
            DataAccessException daex = this.exceptionTranslator != null ? this.exceptionTranslator.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
            return daex != null ? daex : ex;
        }
    }

    private static class ExtendedEntityManagerInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final Log logger = LogFactory.getLog(ExtendedEntityManagerInvocationHandler.class);
        private final EntityManager target;
        private final EntityManagerPlusOperations plusOperations;
        private final PersistenceExceptionTranslator exceptionTranslator;
        private final boolean containerManaged;
        private boolean jta;

        private ExtendedEntityManagerInvocationHandler(EntityManager target, EntityManagerPlusOperations plusOperations, PersistenceExceptionTranslator exceptionTranslator, Boolean jta, boolean containerManaged) {
            this.target = target;
            this.plusOperations = plusOperations;
            this.exceptionTranslator = exceptionTranslator;
            this.jta = jta != null ? jta.booleanValue() : this.isJtaEntityManager();
            this.containerManaged = containerManaged;
        }

        private boolean isJtaEntityManager() {
            try {
                this.target.getTransaction();
                return false;
            }
            catch (IllegalStateException ex) {
                logger.debug("Cannot access EntityTransaction handle - assuming we're in a JTA environment");
                return true;
            }
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("getTargetEntityManager")) {
                return this.target;
            }
            if (method.getName().equals("isOpen")) {
                if (this.containerManaged) {
                    return true;
                }
            } else if (method.getName().equals("close")) {
                if (this.containerManaged) {
                    throw new IllegalStateException("Invalid usage: Cannot close a container-managed EntityManager");
                }
            } else if (method.getName().equals("getTransaction")) {
                if (this.containerManaged) {
                    throw new IllegalStateException("Cannot execute getTransaction() on a container-managed EntityManager");
                }
            } else if (method.getName().equals("joinTransaction")) {
                this.doJoinTransaction(true);
                return null;
            }
            if (this.containerManaged && method.getDeclaringClass().isInterface()) {
                this.doJoinTransaction(false);
            }
            try {
                if (method.getDeclaringClass().equals(EntityManagerPlusOperations.class)) {
                    return method.invoke((Object)this.plusOperations, args);
                }
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }

        private void doJoinTransaction(boolean enforce) {
            if (this.jta) {
                try {
                    this.target.joinTransaction();
                    logger.debug("Joined JTA transaction");
                }
                catch (TransactionRequiredException ex) {
                    if (!enforce) {
                        logger.debug("No JTA transaction to join: " + (Object)((Object)ex));
                    }
                    throw ex;
                }
            } else if (TransactionSynchronizationManager.isSynchronizationActive()) {
                if (!TransactionSynchronizationManager.hasResource(this.target) && !this.target.getTransaction().isActive()) {
                    this.enlistInCurrentTransaction();
                }
                logger.debug("Joined local transaction");
            } else if (!enforce) {
                logger.debug("No local transaction to join");
            } else {
                throw new TransactionRequiredException("No local transaction to join");
            }
        }

        private void enlistInCurrentTransaction() {
            EntityTransaction et = this.target.getTransaction();
            et.begin();
            if (logger.isDebugEnabled()) {
                logger.debug("Starting resource local transaction on application-managed EntityManager [" + this.target + "]");
            }
            ExtendedEntityManagerSynchronization extendedEntityManagerSynchronization = new ExtendedEntityManagerSynchronization(this.target, this.exceptionTranslator);
            TransactionSynchronizationManager.bindResource(this.target, extendedEntityManagerSynchronization);
            TransactionSynchronizationManager.registerSynchronization(extendedEntityManagerSynchronization);
        }
    }
}

