/* vim: set tabstop=4: */
/*
 * This file is part of TraceProto.
 * Copyright 2004-2005 Eric Hope and others; see the AUTHORS file for details.
 *
 * TraceProto is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * TraceProto is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with TraceProto; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef TRACEPROTO_H
#define TRACEPROTO_H 1

#define TP_BUF_SIZE 1024
#define NO_PROMISC 0
#define TP_DONT_FRAG 0x4000
#define SNAPLEN 2048
#define FILTERSIZE 150
#define LINUX_OFFSET 2
#define TP_IF_ARRAY 10
#define TP_TIMESTAMP_LEN 22

enum packet_track {
	TP_PACKET_NO,
	TP_PACKET_MATCH,
	TP_PACKET_TIMEOUT,
	TP_PACKET_DONE
};

/*
 * when adding account types, 
 * TP_ACCOUNT_NONE should be the first listed
 * TP_ACCOUNT_FULL should be the last  listed.
 */
enum accounting {
	TP_ACCOUNT_NONE,
	TP_ACCOUNT_TOTAL,
	TP_ACCOUNT_FULL
};

enum output {
	TP_GRAPHIC_OUTPUT,
	TP_CLASSIC_OUTPUT,
	TP_MIN_OUTPUT,
	TP_SCRIPT_OUTPUT,
	TP_CURSES_OUTPUT,
	TP_STD_OUTPUT,
	TP_NO_OUTPUT
};

enum output_items {
	TP_OUT_HEADER,
	TP_OUT_HOP_NUMBER,
	TP_OUT_HOP_INFO,
	TP_OUT_TIME,
	TP_OUT_FOOTER
};

enum packet_numbers {
	TP_TYPE_NULL,
	TP_TYPE_NR,
	TP_TYPE_SYN,
	TP_TYPE_ACK,
	TP_TYPE_SYNACK,
	TP_TYPE_SEC,
	TP_TYPE_RST,
	TP_TYPE_ACKRST,
	TP_TYPE_FIN,
	TP_TYPE_UDP,
	TP_TYPE_TIMXCEED,
	TP_TYPE_PORT_UNREACH,
	TP_TYPE_HOST_UNREACH,
	TP_TYPE_NET_UNREACH,
	TP_TYPE_ICMP,
	TP_TYPE_ECHOREPLY,
	TP_TYPE_PROHIB,
	TP_TYPE_OTHER
};

enum bool { NO = 0, YES = 1 };

enum tp_tstamps {
	TP_TIMESTAMP_STD = 0,
	TP_TIMESTAMP_US,
	TP_TIMESTAMP_DESCEND,
	TP_TIMESTAMP_EPOCH
};

/*
 * this is used to track the mem malloc'd by tp_align
 * so it can be freed once done with each packet.
 * Otherwise TraceProto slowly turns into the blob that
 * ate your memory.
 */
struct tp_align_ref {
	struct tp_align_ref * next;
	u_char * ref;
} tp_align_freelist;

struct {
	unsigned int continuous : 1;
	unsigned int continuous_accounting : 1;
	unsigned int do_skip : 1;
	unsigned int do_audit_exit : 1;
	unsigned int do_audit : 1;
	unsigned int tcp_resets : 1;
	unsigned int as_discovery : 1;
	unsigned int default_if : 1;
	unsigned int timestamp : 1;
	unsigned int rndm_src_port;
	unsigned int packets_per_hop;
	int max_ttl;
	int min_ttl;
	int min_src_port;
	int max_src_port;
	int min_dst_port;
	int max_dst_port;
	int src_port_incr;
	int dst_port_incr;
	int wait_timeout;
	int wait_between_packets;
	char const * protocol;
	char interface [ TP_IF_ARRAY ];
/*	char * interface; */
	int account_level;
	void ( * report ) ( int, struct in_addr *, int );
	char * skip_str;
	int * skips;
	int output_style;
	unsigned int payload_size;
	char * target;
	struct addrinfo *target_addrinfo_list_start;
	struct addrinfo *target_addrinfo;
	struct hostent * packed_target_reverse; /* deprecated - IPv4 specific */
	char * target_reverse;
	int libnet_resolve_choice;
	int hop_incr_unit;
	char const * filter_text;
	char timestamp_str [ TP_TIMESTAMP_LEN ];
	char timestamp_style;
	struct addrinfo hint;
} behavior;

struct {
	int dst_port;
	int src_port;
	int protocol_number;
	unsigned short ip_packet_len;
	unsigned char * payload;
	unsigned char tcp_flags;
	long packed_target;
	long packed_src;
	unsigned short frag_bit;
	unsigned short ip_id;
} packet;

struct {
	char * prog;
	unsigned int account_hops;
	struct hop_record {
		int distance;
		double min_time;
		double max_time;
		double median_time;
		double ave_time;
		int num_packets;
		int lost_packets;
		int hop_changes;
	} * hop_record;
	int continuous_count;
	libnet_t * packet;
	libnet_ptag_t tcp_h;
	libnet_ptag_t udp_h;
	libnet_ptag_t icmp_h;
	libnet_ptag_t ip_h;
	char pc_error [ PCAP_ERRBUF_SIZE ];
	char * error_buff[LIBNET_ERRBUF_SIZE];
	int current_hop;
	unsigned int packets_this_hop;
	int packet_match;
	struct timeval start_time;
	struct timeval   end_time;
	struct timeval packet_wait;
	double  trip_time;
	pcap_t * psocket;
/*
 * used to sidestep the pcap encapsulation
 * since the wait timeouts for packet captures
 * in pcap don't work on some OSs
 */
	struct fake_pcap {
		int fd;
		char unused [ 1024 ];
	} * fake_psocket;
	fd_set wheel;
	unsigned char * capture_buf;
	struct pcap_pkthdr psock_hdr;
	struct libnet_ipv4_hdr * ip_hdr;
	unsigned int low_ttl;
	unsigned int incr_error : 1;
	unsigned int target_response : 1;
} state;

struct {
	unsigned int loop : 1;
	unsigned int interface : 1;
	unsigned int send_buf : 1;
	unsigned int recv_buf : 1;
	unsigned int packet_length : 1;
	unsigned int timestamp : 1;
	unsigned int as_lookup : 1;
	unsigned int memory : 1;
} debug;

#endif /* TRACEPROTO_H */
