'use client';
import { useRef, useState, useMemo, useEffect } from 'react';

const defaultState = {
  x: 0,
  y: 0,
  width: 0,
  height: 0,
  top: 0,
  left: 0,
  bottom: 0,
  right: 0
};
function useResizeObserver(options) {
  const frameID = useRef(0);
  const ref = useRef(null);
  const [rect, setRect] = useState(defaultState);
  const observer = useMemo(
    () => typeof window !== "undefined" ? new ResizeObserver((entries) => {
      const entry = entries[0];
      if (entry) {
        cancelAnimationFrame(frameID.current);
        frameID.current = requestAnimationFrame(() => {
          if (ref.current) {
            const boxSize = entry.borderBoxSize?.[0] || entry.contentBoxSize?.[0];
            if (boxSize) {
              const width = boxSize.inlineSize;
              const height = boxSize.blockSize;
              setRect({
                width,
                height,
                x: entry.contentRect.x,
                y: entry.contentRect.y,
                top: entry.contentRect.top,
                left: entry.contentRect.left,
                bottom: entry.contentRect.bottom,
                right: entry.contentRect.right
              });
            } else {
              setRect(entry.contentRect);
            }
          }
        });
      }
    }) : null,
    []
  );
  useEffect(() => {
    if (ref.current) {
      observer?.observe(ref.current, options);
    }
    return () => {
      observer?.disconnect();
      if (frameID.current) {
        cancelAnimationFrame(frameID.current);
      }
    };
  }, [ref.current]);
  return [ref, rect];
}
function useElementSize(options) {
  const [ref, { width, height }] = useResizeObserver(options);
  return { ref, width, height };
}

export { useElementSize, useResizeObserver };
//# sourceMappingURL=use-resize-observer.mjs.map
