/*
 * applmon.h -- definitions for the char module
 *
 *********/

#include <linux/ioctl.h>

/*
 * Macros to help debugging
 */

#undef PDEBUG			/* undef it, just in case */
#ifdef APPLMON_DEBUG
#  ifdef __KERNEL__
     /* This one if debugging is on, and kernel space */
#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "applmon: " fmt, ## args)
#  else
     /* This one for user space */
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...)	/* not debugging: nothing */
#endif

#undef PDEBUGG
#define PDEBUGG(fmt, args...)	/* nothing: it's a placeholder */

#define APPLMON_DIAG_CODE 0xdc
#ifdef __s390x__
# define APPLMON_START_REC 0x80
# define APPLMON_STOP_REC  0x81
# define APPLMON_GEN_EVENT 0x82
# define APPLMON_START_CON 0x83
# define APPLMON_PUT_SAMP  0x84
#else
# define APPLMON_START_REC 0x00
# define APPLMON_STOP_REC  0x01
# define APPLMON_GEN_EVENT 0x02
# define APPLMON_START_CON 0x03
# define APPLMON_PUT_SAMP  0x04
#endif

#define APPLMON_BUFSIZE	  4024	/* Applmon buffer size         */

#ifdef __s390x__
typedef struct ApPlist {
	short code;		/* Dianose code                   */
	char fcn;		/* Function code                  */
	char len;		/* Length of parameter list       */
	int unused_1;		/* Unused in z/Architecture       */
	short unused_2;		/* Unused in z/Architecture       */
	short bufLen;		/* Buffer length                  */
	int unused_3;		/* Unused in z/Architecture       */
	char *prodid;		/* Product ID pointer             */
	char *bufAddr;		/* Buffer address                 */
} ApPlist;
#else
typedef struct ApPlist {
	short code;		/* Dianose code                   */
	char fcn;		/* Function code                  */
	char len;		/* Length of parameter list       */
	char *prodid;		/* Product ID pointer             */
	short unused;		/* Reserved                       */
	short bufLen;		/* Buffer length                  */
	char *bufAddr;		/* Buffer address                 */
} ApPlist;
#endif

typedef struct ApplMon_Dev {
	struct ApPlist plist;	/* The APPLDATA parameter list    */
	CPInt_Dev *dev;		/* Pointer to base device         */
	int rc;			/* Return code from diagnose      */
	char product_id[16];	/* Product ID                     */
	int status;		/* Device status                  */
#define APRECSTART 0x01		/* Interval recording started     */
#define APCONSTART 0x02		/* Configuration recording started */
	char *buffer;		/* Monitor record buffer          */
	char *sample;		/* Address of the sample buffer   */
} ApplMon_Dev;

#ifndef min
#  define min(a,b) ((a)<(b) ? (a) : (b))
#endif

/*
 * Ioctl definitions
 */

/* Use 'l' as magic number */
#define APPLMON_IOC_MAGIC  'l'

#define APPLMON_IOCRESET    _IO(APPLMON_IOC_MAGIC, 0)
#define MONSETPROD          _IOW(APPLMON_IOC_MAGIC, 1, char *)

/*
 * S means "Set" through a ptr,
 * T means "Tell" directly with the argument value
 * G means "Get": reply by setting through a pointer
 * Q means "Query": response is on the return value
 * X means "eXchange": G and S atomically
 * H means "sHift": T and Q atomically
 */

/* ... more to come */

#define APPLMON_IOCHARDRESET _IO(APPLMON_IOC_MAGIC, 1)	/* debugging tool */

#define APPLMON_IOC_MAXNR 1
