/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import de.renier.vdr.channel.ChannelElement;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;

/**
 * UnparkAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class UnparkAction extends AbstractAction {

  private static final long serialVersionUID = 934394659505600120L;

  public UnparkAction() {
    super(Messages.getString("UnparkAction.0"), new ImageIcon(OpenAction.class.getResource("/org/javalobby/icons/20x20/BaggageOut.gif"))); //$NON-NLS-1$ //$NON-NLS-2$
    this.setEnabled(false);
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    TreePath targetPath = ChannelEditor.application.getChannelListingPanel().getLeadSelectionPath();
    if (targetPath != null) {
      // find target
      DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode) targetPath.getLastPathComponent();
      ChannelElement channelElementTarget = (ChannelElement) targetNode.getUserObject();
      // loop trough sources
      Object[] sources = ChannelEditor.application.getChannelParkingPanel().getSelectedOrAllElements();
      if (sources != null) {
        // get
        for (int i = 0; i < sources.length; i++) {
          DefaultMutableTreeNode sourceNode = (DefaultMutableTreeNode) sources[i];
          ChannelElement channelElementSource = (ChannelElement) sourceNode.getUserObject();
          // check special insert condition
          if (channelElementSource.isRadioOrTelevisionOrService() && channelElementTarget.isCategory()) {
            // if we move a channel into a category
            ChannelEditor.application.getChannelListingPanel().insertNodeInto(sourceNode, targetNode,
                                                                              targetNode.getChildCount());
          } else {
            // all other get parent and insert node into position
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
            int pos = parentNode.getIndex(targetNode);
            // insert node into parent on selected position
            ChannelEditor.application.getChannelListingPanel().insertNodeInto(sourceNode, parentNode, pos);
          }
          // remove from parking space
          ChannelEditor.application.getChannelParkingPanel().removeElement(sourceNode);
        }
        // mark modified
        ChannelEditor.application.setModified(true);
      }
    }
    /*
     * TreePath[] treepaths = ChannelEditor.application.getChannelListingPanel().getSelectionPaths(); if (treepaths !=
     * null) { for (int i = 0; i < treepaths.length;i++) { TreePath path = treepaths[i]; DefaultMutableTreeNode node =
     * (DefaultMutableTreeNode)path.getLastPathComponent(); DefaultMutableTreeNode parentNode =
     * (DefaultMutableTreeNode)node.getParent(); node.removeFromParent();
     * ChannelEditor.application.getChannelParkingPanel().addElement(node);
     * ChannelEditor.application.getChannelListingPanel().treeNodeStructureChanged(parentNode); } }
     */
  }

}
