/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

import de.renier.vdr.channel.ChannelCategory;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * CreateCategoryAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class CreateCategoryAction extends AbstractAction {

  private static final long serialVersionUID = -1731338871238015167L;

  public CreateCategoryAction() {
    super(Messages.getString("CreateCategoryAction.0"), new ImageIcon(OpenAction.class //$NON-NLS-1$
        .getResource("/org/javalobby/icons/20x20/NewFolder.gif"))); //$NON-NLS-1$
    this.setEnabled(false);
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    TreePath treePath = ChannelEditor.application.getChannelListingPanel().getLeadSelectionPath();
    if (treePath != null) {
      DefaultMutableTreeNode node = (DefaultMutableTreeNode) treePath.getLastPathComponent();
      if (node.isRoot()) {
        // open input dialog to get category name
        String categoryName = JOptionPane.showInputDialog(ChannelEditor.application,
                                                          Messages.getString("CreateCategoryAction.2"), //$NON-NLS-1$
                                                          Messages.getString("CreateCategoryAction.3"), JOptionPane.QUESTION_MESSAGE); //$NON-NLS-1$
        if (!Utils.isEmpty(categoryName)) {
          categoryName = categoryName.trim().replace(':', '|');
          DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ChannelCategory(categoryName));
          ChannelEditor.application.getChannelListingPanel().insertNodeInto(newNode, node, node.getChildCount());
          ChannelEditor.application.getChannelListingPanel().treeNodeStructureChanged(node);
          // mark modified
          ChannelEditor.application.setModified(true);
        }
      }
    }
  }

}
