/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.regex;

import com.tonicsystems.jarjar.regex.Matcher;
import com.tonicsystems.jarjar.regex.Pattern;
import com.tonicsystems.jarjar.regex.RegexEngine;
import com.tonicsystems.jarjar.regexp.RE;
import com.tonicsystems.jarjar.regexp.REException;
import com.tonicsystems.jarjar.regexp.REMatch;

public class GnuRegexEngine
implements RegexEngine {
    public Pattern compile(String pattern) {
        try {
            return new GnuPattern(new RE(pattern));
        }
        catch (REException e) {
            throw new IllegalArgumentException(e.getMessage()){

                public Throwable getCause() {
                    return e;
                }
            };
        }
    }

    private static class GnuPattern
    implements Pattern {
        private final RE re;

        public GnuPattern(RE re) {
            this.re = re;
        }

        public String replaceAll(String value, String replace) {
            return this.re.substituteAll(value, replace, 0, 128);
        }

        public boolean matches(String value) {
            return this.re.isMatch(value);
        }

        public int groupCount() {
            return this.re.getNumSubs();
        }

        public Matcher getMatcher(final String value) {
            final REMatch match = this.re.getMatch(value, 0);
            return new Matcher(){

                public boolean matches() {
                    return GnuPattern.this.re.isMatch(value);
                }

                public int start() {
                    return match.getStartIndex();
                }

                public int end() {
                    return match.getEndIndex();
                }

                public String group(int index) {
                    return match.toString(index);
                }
            };
        }

        public String toString() {
            return this.re.toString();
        }
    }
}

