/* text.tsx generated by @compiled/babel-plugin v0.36.1 */
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inverseColorMap = exports.default = void 0;
require("./text.compiled.css");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _runtime = require("@compiled/react/runtime");
var _tinyInvariant = _interopRequireDefault(require("tiny-invariant"));
var _hasTextAncestorContext = require("../../utils/has-text-ancestor-context");
var _surfaceProvider = require("../../utils/surface-provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var asAllowlist = ['span', 'p', 'strong', 'em'];
/**
 * Custom hook designed to abstract the parsing of the color props and make it clearer in the future how color is reconciled between themes and tokens.
 */
var useColor = function useColor(colorProp, hasTextAncestor) {
  var surface = (0, _surfaceProvider.useSurface)();
  if (colorProp === 'inherit') {
    return undefined;
  }
  if (colorProp) {
    return colorProp;
  }
  if (hasTextAncestor) {
    return undefined;
  }
  if (inverseColorMap.hasOwnProperty(surface)) {
    return inverseColorMap[surface];
  }
  return 'color.text';
};
var styles = {
  root: "_19pkidpf _2hwxidpf _otyridpf _18u0idpf _1i4qfg65",
  'as.strong': "_k48pmoej",
  'as.em': "_zg8l1m30",
  'textAlign.center': "_y3gn1h6o",
  'textAlign.end': "_y3gnh9n0",
  'textAlign.start': "_y3gnv2br",
  truncation: "_1reo15vq _18m915vq _1e0ccj1k _sudp1e54",
  breakAll: "_1nmz9jpi"
};
var fontSizeMap = {
  medium: "_11c82smr",
  UNSAFE_small: "_11c8dcr7",
  large: "_11c81ixg",
  small: "_11c81o8v"
};
var fontWeightMap = {
  bold: "_k48pmoej",
  medium: "_k48p1wq8",
  regular: "_k48pi7a9",
  semibold: "_k48p1pd9"
};
var textColorMap = {
  'color.text': "_syaz1fxt",
  'color.text.accent.lime': "_syaz1tco",
  'color.text.accent.lime.bolder': "_syaz1ik3",
  'color.text.accent.red': "_syaz9lu1",
  'color.text.accent.red.bolder': "_syazhwvp",
  'color.text.accent.orange': "_syaz1q28",
  'color.text.accent.orange.bolder': "_syaz1vps",
  'color.text.accent.yellow': "_syazfb2s",
  'color.text.accent.yellow.bolder': "_syazekll",
  'color.text.accent.green': "_syazh55r",
  'color.text.accent.green.bolder': "_syaz1y78",
  'color.text.accent.teal': "_syaz17qg",
  'color.text.accent.teal.bolder': "_syaz12v7",
  'color.text.accent.blue': "_syazpnps",
  'color.text.accent.blue.bolder': "_syazsc1o",
  'color.text.accent.purple': "_syaz10m5",
  'color.text.accent.purple.bolder': "_syaz2ibx",
  'color.text.accent.magenta': "_syaz1s8m",
  'color.text.accent.magenta.bolder': "_syaz1qur",
  'color.text.accent.gray': "_syaz1dyx",
  'color.text.accent.gray.bolder': "_syaz1x9z",
  'color.text.disabled': "_syaz1lh4",
  'color.text.inverse': "_syaz15cr",
  'color.text.selected': "_syazaqb7",
  'color.text.brand': "_syaz1e6v",
  'color.text.danger': "_syaz1tmw",
  'color.text.warning': "_syazwx40",
  'color.text.warning.inverse': "_syazal3n",
  'color.text.success': "_syazy73q",
  'color.text.discovery': "_syazzjem",
  'color.text.information': "_syaze0os",
  'color.text.subtlest': "_syaz131l",
  'color.text.subtle': "_syaz1gjq",
  'color.link': "_syaz14q2",
  'color.link.pressed': "_syaz16c2",
  'color.link.visited': "_syazw7te",
  'color.link.visited.pressed': "_syazg3x0"
};
var inverseColorMap = exports.inverseColorMap = {
  'color.background.neutral.bold': 'color.text.inverse',
  'color.background.neutral.bold.hovered': 'color.text.inverse',
  'color.background.neutral.bold.pressed': 'color.text.inverse',
  'color.background.selected.bold': 'color.text.inverse',
  'color.background.selected.bold.hovered': 'color.text.inverse',
  'color.background.selected.bold.pressed': 'color.text.inverse',
  'color.background.brand.bold': 'color.text.inverse',
  'color.background.brand.bold.hovered': 'color.text.inverse',
  'color.background.brand.bold.pressed': 'color.text.inverse',
  'color.background.brand.boldest': 'color.text.inverse',
  'color.background.brand.boldest.hovered': 'color.text.inverse',
  'color.background.brand.boldest.pressed': 'color.text.inverse',
  'color.background.danger.bold': 'color.text.inverse',
  'color.background.danger.bold.hovered': 'color.text.inverse',
  'color.background.danger.bold.pressed': 'color.text.inverse',
  'color.background.warning.bold': 'color.text.warning.inverse',
  'color.background.warning.bold.hovered': 'color.text.warning.inverse',
  'color.background.warning.bold.pressed': 'color.text.warning.inverse',
  'color.background.success.bold': 'color.text.inverse',
  'color.background.success.bold.hovered': 'color.text.inverse',
  'color.background.success.bold.pressed': 'color.text.inverse',
  'color.background.discovery.bold': 'color.text.inverse',
  'color.background.discovery.bold.hovered': 'color.text.inverse',
  'color.background.discovery.bold.pressed': 'color.text.inverse',
  'color.background.information.bold': 'color.text.inverse',
  'color.background.information.bold.hovered': 'color.text.inverse',
  'color.background.information.bold.pressed': 'color.text.inverse'
};

/**
 * __Text__
 *
 * Text is a primitive component that has the Atlassian Design System's design guidelines baked in.
 * This includes considerations for text attributes such as color, font size, font weight, and line height.
 * It renders a `span` by default.
 *
 * @internal
 */
var Text = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$as = _ref.as,
    Component = _ref$as === void 0 ? 'span' : _ref$as,
    colorProp = _ref.color,
    align = _ref.align,
    testId = _ref.testId,
    id = _ref.id,
    size = _ref.size,
    weight = _ref.weight,
    maxLines = _ref.maxLines,
    xcss = _ref.xcss,
    children = _ref.children;
  (0, _tinyInvariant.default)(asAllowlist.includes(Component), "@atlaskit/primitives: Text received an invalid \"as\" value of \"".concat(Component, "\""));
  var hasTextAncestor = (0, _hasTextAncestorContext.useHasTextAncestor)();
  var color = useColor(colorProp, hasTextAncestor);
  if (!size && !hasTextAncestor) {
    size = 'medium';
  }
  var component = /*#__PURE__*/React.createElement(Component, {
    id: id,
    className: (0, _runtime.ax)([styles.root, size && fontSizeMap[size], color && textColorMap[color], maxLines && styles.truncation, maxLines === 1 && styles.breakAll, align && styles["textAlign.".concat(align)], weight && fontWeightMap[weight], Component === 'em' && styles['as.em'], Component === 'strong' && styles['as.strong'], xcss]),
    style: {
      WebkitLineClamp: maxLines
    },
    "data-testid": testId,
    ref: ref
  }, children);
  if (hasTextAncestor) {
    // no need to re-apply context if the text is already wrapped
    return component;
  }
  return /*#__PURE__*/React.createElement(_hasTextAncestorContext.HasTextAncestorProvider, {
    value: true
  }, component);
});
var _default = exports.default = Text;