/* anchor.tsx generated by @compiled/babel-plugin v0.36.1 */
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
require("./anchor.compiled.css");
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _runtime = require("@compiled/react/runtime");
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react2 = require("@compiled/react");
var _tinyInvariant = _interopRequireDefault(require("tiny-invariant"));
var _analyticsNext = require("@atlaskit/analytics-next");
var _appProvider = require("@atlaskit/app-provider");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _useId = require("@atlaskit/ds-lib/use-id");
var _interactionContext = _interopRequireDefault(require("@atlaskit/interaction-context"));
var _visuallyHidden = _interopRequireDefault(require("@atlaskit/visually-hidden"));
var _focusable = _interopRequireDefault(require("./focusable"));
var _excluded = ["href", "children", "onClick", "interactionName", "componentName", "analyticsContext", "aria-label", "aria-labelledby", "style", "target", "testId", "xcss", "newWindowLabel"],
  _excluded2 = ["className"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof3(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var styles = {
  root: "_4bfu1r31 _1hms8stv _ajmmnqa1 _vchhusvi"
};
var IS_EXTERNAL_LINK_REGEX = /^(?:(http|https):\/\/)/;
var IS_NON_HTTP_BASED = /^(((mailto|tel|sms|blob):)|(#))/;

/**
 * __Anchor__
 *
 * A primitive for building custom anchor links.
 *
 * - [Examples](https://atlassian.design/components/primitives/anchor/examples)
 * - [Code](https://atlassian.design/components/primitives/anchor/code)
 * - [Usage](https://atlassian.design/components/primitives/anchor/usage)
 */
var AnchorNoRef = function AnchorNoRef(_ref, ref) {
  var href = _ref.href,
    children = _ref.children,
    _ref$onClick = _ref.onClick,
    providedOnClick = _ref$onClick === void 0 ? _noop.default : _ref$onClick,
    interactionName = _ref.interactionName,
    componentName = _ref.componentName,
    analyticsContext = _ref.analyticsContext,
    ariaLabel = _ref['aria-label'],
    ariaLabelledBy = _ref['aria-labelledby'],
    style = _ref.style,
    target = _ref.target,
    testId = _ref.testId,
    xcss = _ref.xcss,
    _ref$newWindowLabel = _ref.newWindowLabel,
    newWindowLabel = _ref$newWindowLabel === void 0 ? '(opens new window)' : _ref$newWindowLabel,
    htmlAttributes = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var interactionContext = (0, _react.useContext)(_interactionContext.default);
  var handleClick = (0, _react.useCallback)(function (e, analyticsEvent) {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  var opensNewWindowLabelId = (0, _useId.useId)();
  var onClick = (0, _analyticsNext.usePlatformLeafEventHandler)({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Anchor',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'link'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = (0, _objectWithoutProperties2.default)(htmlAttributes, _excluded2);
  var RouterLink = (0, _appProvider.useRouterLink)();
  var isExternal = typeof href === 'string' && IS_EXTERNAL_LINK_REGEX.test(href);
  var isNonHttpBased = typeof href === 'string' && IS_NON_HTTP_BASED.test(href);

  /**
   * Renders a router link if:
   *
   * - a link component is set in the app provider
   * - it's not an external link (starting with `http://` or `https://`)
   * - it's not a non-HTTP-based link (e.g. emails, phone numbers, hash links etc.).
   */
  var isRouterLink = RouterLink && !isExternal && !isNonHttpBased;
  var hrefObjectUsedWithoutRouterLink = RouterLink === undefined && (0, _typeof2.default)(href) === 'object';
  (0, _tinyInvariant.default)(!hrefObjectUsedWithoutRouterLink, "@atlaskit/primitives: Anchor primitive cannot pass an object to 'href' unless a router link is configured in the AppProvider");
  var Component = isRouterLink ? RouterLink : 'a';
  return /*#__PURE__*/React.createElement(_focusable.default
  // @ts-expect-error we don't allow `a` on Focusable for makers as they should use Anchor instead
  , (0, _extends2.default)({
    as: Component,
    className: xcss
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- TODO: Properly type this and allow pass-through if we can determine the type
    ,
    style: style,
    ref: ref
    // eslint-disable-next-line @repo/internal/react/no-unsafe-spread-props
  }, safeHtmlAttributes, {
    href: !isRouterLink && typeof href !== 'string' ? undefined : href,
    target: target,
    onClick: onClick,
    "aria-label": ariaLabel && target === '_blank' && !ariaLabelledBy ? "".concat(ariaLabel, " , ").concat(newWindowLabel) : ariaLabel,
    "aria-labelledby": ariaLabelledBy && target === '_blank' ? "".concat(ariaLabelledBy, " ").concat(opensNewWindowLabelId) : ariaLabelledBy,
    xcss: (0, _react2.cx)(styles.root, xcss),
    testId: testId,
    "data-is-router-link": testId ? isRouterLink ? 'true' : 'false' : undefined
  }), children, target === '_blank' && (children && !ariaLabel && !ariaLabelledBy || ariaLabelledBy) && /*#__PURE__*/React.createElement(_visuallyHidden.default, {
    id: opensNewWindowLabelId
  }, ", ".concat(newWindowLabel)));
};

// Workarounds to support generic types with forwardRef
/**
 * __Anchor__
 *
 * Anchor is a primitive for building custom anchor links. It's a wrapper around the HTML `<a>` element that provides a consistent API for handling client-side routing and Atlassian Design System styling.
 *
 * - [Examples](https://atlassian.design/components/primitives/anchor/examples)
 * - [Code](https://atlassian.design/components/primitives/anchor/code)
 * - [Usage](https://atlassian.design/components/primitives/anchor/usage)
 */
var Anchor = /*#__PURE__*/(0, _react.forwardRef)(AnchorNoRef);
var _default = exports.default = Anchor;