"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValue = exports.default = void 0;
var _constants = require("../../constants");
var _dampenValueByTime = require("./dampen-value-by-time");
var _getValueFromDistance = require("./get-value-from-distance");
// Source: https://github.com/atlassian/react-beautiful-dnd

var getValue = exports.getValue = function getValue(_ref) {
  var distanceToEdge = _ref.distanceToEdge,
    thresholds = _ref.thresholds,
    dragStartTime = _ref.dragStartTime,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  var scroll = (0, _getValueFromDistance.getValueFromDistance)(distanceToEdge, thresholds);

  // not enough distance to trigger a minimum scroll
  // we can bail here
  if (scroll === 0) {
    return 0;
  }

  // Dampen an auto scroll speed based on duration of drag

  if (!shouldUseTimeDampening) {
    return scroll;
  }

  // Once we know an auto scroll should occur based on distance,
  // we must let at least 1px through to trigger a scroll event an
  // another auto scroll call

  return Math.max((0, _dampenValueByTime.dampenValueByTime)(scroll, dragStartTime), _constants.minScroll);
};
var _default = exports.default = getValue;