import { PersistentOverrideAdapter } from './PersistentOverrideAdapter';
export type LocalOverrides = {
    gates: Record<string, boolean>;
    configs: Record<string, Record<string, unknown>>;
    layers: LocalOverrides['configs'];
};
/**
 * FileOverrideAdapter provides file system based persistence for feature gate, dynamic config,
 * experiment, and layer overrides. It is designed for local development and CLI environments,
 * where browser-specific storage mechanisms (like localStorage) are not available.
 */
export declare class FilePersistentOverrideAdapter extends PersistentOverrideAdapter {
    private _filePath;
    private _browserWarningShown;
    constructor(filePath: string);
    /**
     * Warns if the adapter is being used in a browser environment.
     * This is a non-blocking warning that will only be shown once.
     */
    private warnIfBrowserEnvironment;
    private readStoredOverrides;
    private saveOverridesToFile;
    initFromStoredOverrides(): void;
    saveOverrides(): void;
    removeAllOverrides(): void;
}
