import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _get from "@babel/runtime/helpers/get";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, o, e, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), o, e); return 2 & r && "function" == typeof p ? function (t) { return p.apply(e, t); } : p; }
/// <reference types="node" />
import AnalyticsEvent from './AnalyticsEvent';
export var isUIAnalyticsEvent = function isUIAnalyticsEvent(obj) {
  var _obj$constructor;
  return obj instanceof UIAnalyticsEvent || !!(obj !== null && obj !== void 0 && obj._isUIAnalyticsEvent) ||
  // Backwards compatibility with older analytics-next packages
  (obj === null || obj === void 0 || (_obj$constructor = obj.constructor) === null || _obj$constructor === void 0 ? void 0 : _obj$constructor.name) === 'UIAnalyticsEvent';
};
var UIAnalyticsEvent = /*#__PURE__*/function (_AnalyticsEvent) {
  function UIAnalyticsEvent(props) {
    var _this;
    _classCallCheck(this, UIAnalyticsEvent);
    _this = _callSuper(this, UIAnalyticsEvent, [props]);
    _defineProperty(_this, "_isUIAnalyticsEvent", true);
    _defineProperty(_this, "clone", function () {
      if (_this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot clone an event after it's been fired.");
        }
        return null;
      }
      var context = _toConsumableArray(_this.context);
      var handlers = _toConsumableArray(_this.handlers);

      /**
       * A hacky "deep clone" of the object. This is limited in that it wont
       * support functions, regexs, Maps, Sets, etc, but none of those need to
       * be represented in our payload.
       */
      var payload = JSON.parse(JSON.stringify(_this.payload));
      return new UIAnalyticsEvent({
        context: context,
        handlers: handlers,
        payload: payload
      });
    });
    _defineProperty(_this, "fire", function (channel) {
      if (_this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn('Cannot fire an event twice.');
        }
        return;
      }
      _this.handlers.forEach(function (handler) {
        return handler(_this, channel);
      });
      _this.hasFired = true;
    });
    _this.context = props.context || [];
    _this.handlers = props.handlers || [];
    _this.hasFired = false;
    return _this;
  }
  _inherits(UIAnalyticsEvent, _AnalyticsEvent);
  return _createClass(UIAnalyticsEvent, [{
    key: "update",
    value: function update(updater) {
      if (this.hasFired) {
        if (process.env.NODE_ENV !== 'production' && !process.env.CI) {
          // eslint-disable-next-line no-console
          console.warn("Cannot update an event after it's been fired.");
        }
        return this;
      }
      return _superPropGet(UIAnalyticsEvent, "update", this, 3)([updater]);
    }
  }]);
}(AnalyticsEvent);
export { UIAnalyticsEvent as default };