import { useCallbackOne } from 'use-memo-one';
import UIAnalyticsEvent from '../events/UIAnalyticsEvent';
import { useAnalyticsContext } from './useAnalyticsContext';
export function useAnalyticsEvents() {
  const analyticsContext = useAnalyticsContext();
  const createAnalyticsEvent = useCallbackOne(payload => {
    return new UIAnalyticsEvent({
      context: analyticsContext.getAtlaskitAnalyticsContext(),
      handlers: analyticsContext.getAtlaskitAnalyticsEventHandlers(),
      payload
    });
  }, [analyticsContext]);
  return {
    createAnalyticsEvent
  };
}