/*
 * asprintf - Incenp.org Notch Library: (v)asprintf replacement
 * Copyright (C) 2011 Damien Goutte-Gattat
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>

int
vasprintf(char **strp, const char *fmt, va_list ap)
{
    int n;
    va_list aq;

    if ( ! strp ) {
        errno = EINVAL;
        return -1;
    }

    n = vsnprintf(NULL, 0, fmt, ap) + 1;
    if ( ! (*strp = malloc(n)) )
        return -1;

    va_copy(ap, aq);
    n = vsnprintf(*strp, n, fmt, aq);
    va_end(aq);

    return n;
}

int
asprintf(char **strp, const char *fmt, ...)
{
    int n;
    va_list ap;

    va_start(ap, fmt);
    n = vasprintf(strp, fmt, ap);
    va_end(ap);

    return n;
}
