/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.warmup;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheWarmup {
    private static final Log log = LogFactory.getLog(CacheWarmup.class);
    private Map<String, String> configParams = new HashMap<String, String>();

    public void setConfigParams(Map<String, String> configParams) {
        this.configParams = configParams;
    }

    public String getConfigParam(String name) {
        return this.configParams.get(name);
    }

    public final void warmup(CacheWrapper cacheWrapper) {
        long startTime = System.currentTimeMillis();
        try {
            this.performWarmupOperations(cacheWrapper);
        }
        catch (Exception e) {
            log.warn((Object)("Received exception durring cache warmup" + e.getMessage()));
        }
        log.info((Object)("The warmup took: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds."));
        try {
            cacheWrapper.empty();
        }
        catch (Exception e) {
            log.warn((Object)"Received exception durring cache warmup", (Throwable)e);
        }
    }

    public abstract void performWarmupOperations(CacheWrapper var1) throws Exception;
}

