/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators.reportcentralizer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cachebench.reportgenerators.reportcentralizer.ConfigurationData;
import org.cachebench.reportgenerators.reportcentralizer.ReportData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportCentralizer {
    public static final String SEPARATOR = ", ";
    private String sourceReportDirectory;
    private String destinationReportDirectory;

    public ReportCentralizer(String reportsSourceDir, String reportsDestDir) throws Exception {
        this.sourceReportDirectory = reportsSourceDir;
        this.destinationReportDirectory = reportsDestDir;
        this.process();
    }

    private void process() throws Exception {
        File[] files = this.getReportFiles();
        ArrayList<ReportData> reportDatas = this.parseFiles(files);
        List<ConfigurationData> configurationDatas = this.buildBenchmarkData(reportDatas);
        this.updateConfigurationDatas(reportDatas, configurationDatas);
        this.generateReports(configurationDatas);
    }

    private void generateReports(List<ConfigurationData> configurationDatas) throws IOException {
        File destDir = new File(this.destinationReportDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        for (ConfigurationData configData : configurationDatas) {
            File reportFile = new File(destDir, configData.getConfigurationName() + ".csv");
            reportFile.createNewFile();
            PrintStream printStream = new PrintStream(reportFile);
            this.writeHeader(printStream, configData.getClusterSizes());
            Map<String, List<ReportData>> map = configData.getDistriution2ReportDataMap();
            for (Map.Entry<String, List<ReportData>> entry : map.entrySet()) {
                this.printProduct(printStream, entry);
            }
            printStream.flush();
            printStream.close();
        }
    }

    private void printProduct(PrintStream printStream, Map.Entry<String, List<ReportData>> entry) {
        printStream.print(entry.getKey());
        for (ReportData reportData : entry.getValue()) {
            printStream.print(SEPARATOR + reportData.getAvgReqPerSec());
        }
        printStream.println();
    }

    private void writeHeader(PrintStream printStream, int[] clusterSizes) {
        printStream.print("Cluster Size");
        for (int i = 0; i < clusterSizes.length; ++i) {
            printStream.print(SEPARATOR + i);
        }
        printStream.println();
    }

    private void updateConfigurationDatas(List<ReportData> reportDatas, List<ConfigurationData> configurationDatas) {
        for (ReportData data : reportDatas) {
            for (ConfigurationData configurationData : configurationDatas) {
                configurationData.addIfNeeded(data);
            }
        }
    }

    private List<ConfigurationData> buildBenchmarkData(List<ReportData> reportDatas) {
        HashSet<String> alreadyProcessed = new HashSet<String>();
        ArrayList<ConfigurationData> result = new ArrayList<ConfigurationData>();
        for (ReportData reportData : reportDatas) {
            if (alreadyProcessed.contains(reportData.getConfiguration())) continue;
            alreadyProcessed.add(reportData.getConfiguration());
            result.add(new ConfigurationData(reportData.getConfiguration()));
        }
        return result;
    }

    private ArrayList<ReportData> parseFiles(File[] files) throws Exception {
        ArrayList<ReportData> reportDatas = new ArrayList<ReportData>();
        for (File file : files) {
            reportDatas.add(new ReportData(file));
        }
        return reportDatas;
    }

    private File[] getReportFiles() {
        File file = new File(this.sourceReportDirectory);
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException("Report directory " + this.sourceReportDirectory + " does not exist or is not a directory!");
        }
        return file.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".CSV");
            }
        });
    }

    public static void main(String[] args) throws Exception {
        String sourceDir = "c:\\temp\\centralizer\\in_real2";
        String destDir = "c:\\temp\\centralizer\\in_real2\\centralized";
        new ReportCentralizer(sourceDir, destDir);
    }
}

