/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.reportgenerators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.reportgenerators.AbstractReportGenerator;
import org.cachebench.tests.results.TestResult;

public abstract class CsvBaseReportGenerator
extends AbstractReportGenerator {
    protected static Log log = LogFactory.getLog(CsvBaseReportGenerator.class);
    private ArrayList footNotes;

    public void generate() throws Exception {
        try {
            BufferedWriter writer = null;
            log.debug((Object)("Opening output file [" + this.output + "]"));
            this.prepareReportFile();
            writer = new BufferedWriter(new FileWriter(this.output));
            this.writeHeaderLine(writer);
            for (TestResult result : this.results) {
                this.writeTestResult(result, writer);
                this.checkForFootnotes(result);
            }
            if (this.footNotes != null) {
                this.writeFoodNotes(writer);
            }
            writer.close();
            log.debug((Object)"Report complete");
            if (this.output.exists()) {
                log.warn((Object)("Expected report file:'" + this.output.getAbsoluteFile() + "'does not exist!"));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error appeared while generatin report:", (Throwable)e);
        }
    }

    private void checkForFootnotes(TestResult result) {
        if (!"".equals(result.getFootNote())) {
            if (this.footNotes == null) {
                this.footNotes = new ArrayList();
            }
            this.footNotes.add(result.getFootNote());
            log.debug((Object)("Foot node found, added " + result.getFootNote()));
        }
    }

    protected abstract void writeTestResult(TestResult var1, BufferedWriter var2) throws IOException;

    protected abstract void writeHeaderLine(BufferedWriter var1) throws IOException;

    private void prepareReportFile() throws IOException {
        String fileName = this.output.getAbsolutePath() + ".old." + System.currentTimeMillis();
        if (this.output.exists()) {
            log.info((Object)("A file named: '" + this.output.getAbsolutePath() + "' already exist. Renaming to '" + fileName + "'"));
            if (this.output.renameTo(new File(fileName))) {
                log.warn((Object)"Could not rename!!!");
            }
        } else if (this.output.createNewFile()) {
            log.info((Object)("Successfully created report file:" + this.output.getAbsolutePath()));
        } else {
            log.warn((Object)"Failed to create the report file!");
        }
    }

    private void writeFoodNotes(BufferedWriter writer) throws IOException {
        log.debug((Object)"Writing the Footnotes");
        writer.newLine();
        writer.newLine();
        writer.newLine();
        writer.newLine();
        writer.write("Report FootNotes");
        writer.newLine();
        int footNoteSize = this.footNotes.size();
        for (int i = 0; i < footNoteSize; ++i) {
            writer.write((String)this.footNotes.get(i));
            writer.newLine();
        }
        log.debug((Object)"Complted the Footnotes");
    }
}

